/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.resource;

import com.hazelcast.cluster.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;

public class SlotProfile
implements IdentifiedDataSerializable {
    private Address worker;
    private int slotID;
    private long ownerJobID;
    private volatile boolean assigned;
    private ResourceProfile resourceProfile;
    private String sequence;

    public SlotProfile() {
        this.worker = new Address();
    }

    public SlotProfile(Address worker, int slotID, ResourceProfile resourceProfile, String sequence) {
        this.worker = worker;
        this.slotID = slotID;
        this.resourceProfile = resourceProfile;
        this.sequence = sequence;
    }

    public Address getWorker() {
        return this.worker;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public long getOwnerJobID() {
        return this.ownerJobID;
    }

    public void assign(long jobID) {
        if (this.assigned) {
            throw new UnsupportedOperationException();
        }
        this.ownerJobID = jobID;
        this.assigned = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotProfile that = (SlotProfile)o;
        return this.slotID == that.slotID && this.worker.equals((Object)that.worker) && this.sequence.equals(that.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.worker, this.slotID, this.sequence);
    }

    public String getSequence() {
        return this.sequence;
    }

    public void unassigned() {
        this.assigned = false;
    }

    public String toString() {
        return "SlotProfile{worker=" + this.worker + ", slotID=" + this.slotID + ", ownerJobID=" + this.ownerJobID + ", assigned=" + this.assigned + ", resourceProfile=" + this.resourceProfile + ", sequence='" + this.sequence + '\'' + '}';
    }

    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 6;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.worker);
        out.writeInt(this.slotID);
        out.writeLong(this.ownerJobID);
        out.writeBoolean(this.assigned);
        out.writeObject((Object)this.resourceProfile);
        out.writeString(this.sequence);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.worker = (Address)in.readObject();
        this.slotID = in.readInt();
        this.ownerJobID = in.readLong();
        this.assigned = in.readBoolean();
        this.resourceProfile = (ResourceProfile)in.readObject();
        this.sequence = in.readString();
    }
}

