/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.ClientToServerOperationDataSerializerHook;

public class UploadConnectorJarOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;
    private Data connectorJar;
    private Data response;

    public UploadConnectorJarOperation() {
    }

    public UploadConnectorJarOperation(long jobId, Data connectorJar) {
        this.jobId = jobId;
        this.connectorJar = connectorJar;
    }

    public int getFactoryId() {
        return ClientToServerOperationDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 11;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
        IOUtil.writeData((ObjectDataOutput)out, (Data)this.connectorJar);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
        this.connectorJar = IOUtil.readData((ObjectDataInput)in);
    }

    public void run() throws Exception {
        SeaTunnelServer service = (SeaTunnelServer)this.getService();
        CompletableFuture<Data> future = CompletableFuture.supplyAsync(() -> {
            ConnectorJarIdentifier connectorJarIdentifier = service.getConnectorPackageService().storageConnectorJarFile(this.jobId, this.connectorJar);
            return this.getNodeEngine().toData((Object)connectorJarIdentifier);
        }, (Executor)this.getNodeEngine().getExecutionService().getExecutor("upload_connector_jar_operation"));
        try {
            this.response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SeaTunnelEngineException((Throwable)e);
        }
    }

    public Object getResponse() {
        return this.response;
    }
}

