/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class TaskLocation
implements IdentifiedDataSerializable,
Serializable {
    private TaskGroupLocation taskGroupLocation;
    private long taskID;
    private int index;

    public TaskLocation() {
    }

    public TaskLocation(TaskGroupLocation taskGroupLocation, long idPrefix, int index) {
        this.taskGroupLocation = taskGroupLocation;
        this.taskID = this.mixIDPrefixAndIndex(idPrefix, index);
        this.index = index;
    }

    private long mixIDPrefixAndIndex(long idPrefix, int index) {
        return idPrefix * 10000L + (long)index;
    }

    public TaskGroupLocation getTaskGroupLocation() {
        return this.taskGroupLocation;
    }

    public long getJobId() {
        return this.taskGroupLocation.getJobId();
    }

    public int getPipelineId() {
        return this.taskGroupLocation.getPipelineId();
    }

    public long getTaskID() {
        return this.taskID;
    }

    public long getTaskVertexId() {
        return this.taskID / 10000L;
    }

    public int getTaskIndex() {
        return this.index;
    }

    public void setTaskGroupLocation(TaskGroupLocation taskGroupLocation) {
        this.taskGroupLocation = taskGroupLocation;
    }

    public void setTaskID(long taskID) {
        this.taskID = taskID;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 9;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.taskGroupLocation);
        out.writeLong(this.taskID);
        out.writeInt(this.index);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.taskGroupLocation = (TaskGroupLocation)in.readObject();
        this.taskID = in.readLong();
        this.index = in.readInt();
    }

    public String toString() {
        return "TaskLocation{taskGroupLocation=" + this.taskGroupLocation + ", taskID=" + this.taskID + ", index=" + this.index + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLocation that = (TaskLocation)o;
        return new EqualsBuilder().append(this.taskID, that.taskID).append((Object)this.taskGroupLocation, (Object)that.taskGroupLocation).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.taskGroupLocation).append(this.taskID).toHashCode();
    }
}

