/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;

public class SourceNoMoreElementOperation
extends Operation
implements IdentifiedDataSerializable {
    private TaskLocation currentTaskID;
    private TaskLocation enumeratorTaskID;

    public SourceNoMoreElementOperation() {
    }

    public SourceNoMoreElementOperation(TaskLocation currentTaskID, TaskLocation enumeratorTaskID) {
        this.currentTaskID = currentTaskID;
        this.enumeratorTaskID = enumeratorTaskID;
    }

    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            ClassLoader classLoader = server.getTaskExecutionService().getExecutionContext(this.enumeratorTaskID.getTaskGroupLocation()).getClassLoader();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.enumeratorTaskID);
            task.readerFinished(this.currentTaskID);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.enumeratorTaskID.getTaskGroupLocation()), 2000L));
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.currentTaskID);
        out.writeObject((Object)this.enumeratorTaskID);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.currentTaskID = (TaskLocation)in.readObject();
        this.enumeratorTaskID = (TaskLocation)in.readObject();
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 5;
    }
}

