/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.core.starter.utils.ConfigShadeUtils;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpPostCommandProcessor;
import org.apache.seatunnel.engine.server.operation.CancelJobOperation;
import org.apache.seatunnel.engine.server.operation.SavePointJobOperation;
import org.apache.seatunnel.engine.server.operation.SubmitJobOperation;
import org.apache.seatunnel.engine.server.rest.RestJobExecutionEnvironment;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.engine.server.utils.RestUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;

public class RestHttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private final Log4j2HttpPostCommandProcessor original;

    public RestHttpPostCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpPostCommandProcessor(textCommandService));
    }

    protected RestHttpPostCommandProcessor(TextCommandService textCommandService, Log4j2HttpPostCommandProcessor log4j2HttpPostCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpPostCommandProcessor.class));
        this.original = log4j2HttpPostCommandProcessor;
    }

    public void handle(HttpPostCommand httpPostCommand) {
        String uri = httpPostCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/submit-job")) {
                this.handleSubmitJob(httpPostCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/stop-job")) {
                this.handleStopJob(httpPostCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/encrypt-config")) {
                this.handleEncrypt(httpPostCommand);
            } else {
                this.original.handle(httpPostCommand);
            }
        }
        catch (IllegalArgumentException e) {
            this.prepareResponse(HttpStatusCode.SC_400, (HttpCommand)httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse((Throwable)e));
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpPostCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse((Throwable)e));
        }
        this.textCommandService.sendResponse((TextCommand)httpPostCommand);
    }

    private SeaTunnelServer getSeaTunnelServer() {
        Map extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        return (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
    }

    private void handleSubmitJob(HttpPostCommand httpPostCommand, String uri) throws IllegalArgumentException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        RestUtil.buildRequestParams(requestParams, uri);
        Config config = RestUtil.buildConfig(this.requestHandle(httpPostCommand), false);
        ReadonlyConfig envOptions = ReadonlyConfig.fromConfig((Config)config.getConfig("env"));
        String jobName = (String)envOptions.get(EnvCommonOptions.JOB_NAME);
        JobConfig jobConfig = new JobConfig();
        jobConfig.setName(StringUtils.isEmpty((CharSequence)((CharSequence)requestParams.get("jobName"))) ? jobName : (String)requestParams.get("jobName"));
        boolean startWithSavePoint = Boolean.parseBoolean((String)requestParams.get("isStartWithSavePoint"));
        String jobIdStr = (String)requestParams.get("jobId");
        Long finalJobId = StringUtils.isNotBlank((CharSequence)jobIdStr) ? Long.valueOf(Long.parseLong(jobIdStr)) : null;
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer();
        RestJobExecutionEnvironment restJobExecutionEnvironment = new RestJobExecutionEnvironment(seaTunnelServer, jobConfig, config, this.textCommandService.getNode(), startWithSavePoint, finalJobId);
        JobImmutableInformation jobImmutableInformation = restJobExecutionEnvironment.build();
        long jobId = jobImmutableInformation.getJobId();
        if (!seaTunnelServer.isMasterNode()) {
            NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new SubmitJobOperation(jobId, this.getNode().nodeEngine.toData((Object)jobImmutableInformation), jobImmutableInformation.isStartWithSavePoint())).join();
        } else {
            this.submitJob(seaTunnelServer, jobImmutableInformation, jobConfig);
        }
        this.prepareResponse((HttpCommand)httpPostCommand, new JsonObject().add("jobId", String.valueOf(jobId)).add("jobName", jobConfig.getName()));
    }

    private void handleStopJob(HttpPostCommand httpPostCommand, String uri) {
        SeaTunnelServer seaTunnelServer;
        Map map = JsonUtils.toMap((JsonNode)this.requestHandle(httpPostCommand));
        boolean isStopWithSavePoint = false;
        if (map.get("jobId") == null) {
            throw new IllegalArgumentException("jobId cannot be empty.");
        }
        long jobId = Long.parseLong(map.get("jobId").toString());
        if (map.get("isStopWithSavePoint") != null) {
            isStopWithSavePoint = Boolean.parseBoolean(map.get("isStopWithSavePoint").toString());
        }
        if (!(seaTunnelServer = this.getSeaTunnelServer()).isMasterNode()) {
            if (isStopWithSavePoint) {
                NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new SavePointJobOperation(jobId)).join();
            } else {
                NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new CancelJobOperation(jobId)).join();
            }
        } else {
            CoordinatorService coordinatorService = seaTunnelServer.getCoordinatorService();
            if (isStopWithSavePoint) {
                coordinatorService.savePoint(jobId);
            } else {
                coordinatorService.cancelJob(jobId);
            }
        }
        this.prepareResponse((HttpCommand)httpPostCommand, new JsonObject().add("jobId", map.get("jobId").toString()));
    }

    private void handleEncrypt(HttpPostCommand httpPostCommand) {
        Config config = RestUtil.buildConfig(this.requestHandle(httpPostCommand), true);
        Config encryptConfig = ConfigShadeUtils.encryptConfig((Config)config);
        String encryptString = encryptConfig.root().render(ConfigRenderOptions.concise().setJson(true));
        JsonObject jsonObject = Json.parse((String)encryptString).asObject();
        this.prepareResponse((HttpCommand)httpPostCommand, jsonObject);
    }

    public void handleRejection(HttpPostCommand httpPostCommand) {
        this.handle(httpPostCommand);
    }

    private JsonNode requestHandle(HttpPostCommand httpPostCommand) {
        JsonNode requestBodyJsonNode;
        byte[] requestBody = httpPostCommand.getData();
        if (requestBody.length == 0) {
            throw new IllegalArgumentException("Request body is empty.");
        }
        try {
            requestBodyJsonNode = RestUtil.convertByteToJsonNode(requestBody);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON format in request body.");
        }
        return requestBodyJsonNode;
    }

    private void submitJob(SeaTunnelServer seaTunnelServer, JobImmutableInformation jobImmutableInformation, JobConfig jobConfig) {
        CoordinatorService coordinatorService = seaTunnelServer.getCoordinatorService();
        Data data = this.textCommandService.getNode().nodeEngine.getSerializationService().toData((Object)jobImmutableInformation);
        PassiveCompletableFuture<Void> voidPassiveCompletableFuture = coordinatorService.submitJob(Long.parseLong(jobConfig.getJobContext().getJobId()), data, jobImmutableInformation.isStartWithSavePoint());
        voidPassiveCompletableFuture.join();
    }
}

