/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.TaskTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCallTimer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TaskCallTimer.class);
    long nextExecutionTime;
    long delay;
    TaskExecutionService.CooperativeTaskWorker cooperativeTaskWorker;
    AtomicBoolean keep;
    TaskExecutionService.RunBusWorkSupplier runBusWorkSupplier;
    TaskTracker taskTracker;
    private final Object lock = new Object();
    boolean started = false;
    AtomicBoolean wait0 = new AtomicBoolean(false);

    public TaskCallTimer(long delay, AtomicBoolean keep, TaskExecutionService.RunBusWorkSupplier runBusWorkSupplier, TaskExecutionService.CooperativeTaskWorker cooperativeTaskWorker) {
        this.delay = delay;
        this.keep = keep;
        this.runBusWorkSupplier = runBusWorkSupplier;
        this.cooperativeTaskWorker = cooperativeTaskWorker;
    }

    private void startTimer() {
        this.nextExecutionTime = System.currentTimeMillis() + this.delay;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reSet(long tmpDelay) {
        this.nextExecutionTime = System.currentTimeMillis() + tmpDelay;
        if (this.started) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        } else {
            this.started = true;
            this.start();
        }
    }

    public void reSet() {
        this.nextExecutionTime = System.currentTimeMillis() + this.delay;
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerStart(TaskTracker taskTracker) {
        this.wait0.set(false);
        this.taskTracker = taskTracker;
        this.nextExecutionTime = System.currentTimeMillis() + this.delay;
        if (this.started) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        } else {
            this.started = true;
            this.start();
        }
    }

    public void timerStop() {
        this.wait0.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                long executionTime;
                long currentTime;
                boolean wait;
                Object object = this;
                synchronized (object) {
                    wait = this.wait0.get();
                    currentTime = System.currentTimeMillis();
                    executionTime = this.nextExecutionTime;
                    if (!wait && executionTime <= currentTime) {
                        this.timeoutAct(this.taskTracker.expiredTimes.incrementAndGet());
                        break;
                    }
                }
                if (wait) {
                    object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                        continue;
                    }
                }
                object = this.lock;
                synchronized (object) {
                    this.lock.wait(executionTime - currentTime);
                    continue;
                }
            }
            catch (InterruptedException e) {
                log.warn("TaskCallTimer thread interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void timeoutAct(int expiredTimes) {
        if (expiredTimes >= 1) {
            this.keep.set(true);
            this.cooperativeTaskWorker.exclusiveTaskTracker.set(this.taskTracker);
            this.runBusWorkSupplier.runNewBusWork(false);
        } else {
            this.keep.set(false);
            this.runBusWorkSupplier.runNewBusWork(false);
        }
    }
}

