/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAcknowledgeOperation
extends Operation
implements IdentifiedDataSerializable {
    private static final Logger log = LoggerFactory.getLogger(TaskAcknowledgeOperation.class);
    private TaskLocation taskLocation;
    private CheckpointBarrier barrier;
    private List<ActionSubtaskState> states;

    public TaskAcknowledgeOperation() {
    }

    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 3;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.taskLocation);
        out.writeObject((Object)this.barrier);
        out.writeObject(this.states);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        this.taskLocation = (TaskLocation)in.readObject();
        this.barrier = (CheckpointBarrier)in.readObject();
        this.states = (List)in.readObject();
    }

    public void run() {
        log.debug("TaskAcknowledgeOperation {}", (Object)this.taskLocation);
        ((SeaTunnelServer)this.getService()).getCoordinatorService().getJobMaster(this.taskLocation.getJobId()).getCheckpointManager().acknowledgeTask(this);
        log.debug("task ack finished {}", (Object)this.taskLocation);
    }

    public TaskLocation getTaskLocation() {
        return this.taskLocation;
    }

    public CheckpointBarrier getBarrier() {
        return this.barrier;
    }

    public List<ActionSubtaskState> getStates() {
        return this.states;
    }

    public TaskAcknowledgeOperation(TaskLocation taskLocation, CheckpointBarrier barrier, List<ActionSubtaskState> states) {
        this.taskLocation = taskLocation;
        this.barrier = barrier;
        this.states = states;
    }
}

