/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class NotifyTaskStartOperation
extends TaskOperation {
    public NotifyTaskStartOperation(TaskLocation taskLocation) {
        super(taskLocation);
    }

    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 6;
    }

    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            AbstractTask task = (AbstractTask)server.getTaskExecutionService().getTask(this.taskLocation);
            task.startCall();
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException || exception instanceof NullPointerException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public NotifyTaskStartOperation() {
    }
}

