/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskGroupContext;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class CheckpointEndOperation
extends TaskOperation {
    private long checkpointId;
    private boolean successful;

    public CheckpointEndOperation(TaskLocation taskLocation, long checkpointId, boolean successful) {
        super(taskLocation);
        this.checkpointId = checkpointId;
        this.successful = successful;
    }

    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.checkpointId);
        out.writeBoolean(this.successful);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.checkpointId = in.readLong();
        this.successful = in.readBoolean();
    }

    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            try {
                TaskGroupContext groupContext = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation());
                Object task = groupContext.getTaskGroup().getTask(this.taskLocation.getTaskID());
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(groupContext.getClassLoader());
                task.notifyCheckpointEnd(this.checkpointId);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Exception e) {
                throw new SeaTunnelEngineException(ExceptionUtils.getMessage((Throwable)e));
            }
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public CheckpointEndOperation() {
    }
}

