/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.instance.impl.DefaultNodeContext;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Joiner;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.LiteNodeDropOutTcpIpJoiner;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelNodeContext
extends DefaultNodeContext {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelNodeContext.class);
    private final SeaTunnelConfig seaTunnelConfig;

    public SeaTunnelNodeContext(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.seaTunnelConfig = seaTunnelConfig;
    }

    public com.hazelcast.instance.impl.NodeExtension createNodeExtension(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return new NodeExtension(node, this.seaTunnelConfig);
    }

    public Joiner createJoiner(Node node) {
        JoinConfig join = ConfigAccessor.getActiveMemberNetworkConfig((Config)this.seaTunnelConfig.getHazelcastConfig()).getJoin();
        join.verify();
        if (node.shouldUseMulticastJoiner(join) && node.multicastService != null) {
            super.createJoiner(node);
        } else {
            if (join.getTcpIpConfig().isEnabled()) {
                log.info("Using LiteNodeDropOutTcpIpJoiner TCP/IP discovery");
                return new LiteNodeDropOutTcpIpJoiner(node);
            }
            if (node.getProperties().getBoolean(ClusterProperty.DISCOVERY_SPI_ENABLED) || SeaTunnelNodeContext.isAnyAliasedConfigEnabled(join) || join.isAutoDetectionEnabled()) {
                super.createJoiner(node);
            }
        }
        return null;
    }

    private static boolean isAnyAliasedConfigEnabled(JoinConfig join) {
        return !AliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs((JoinConfig)join).isEmpty();
    }

    private boolean usePublicAddress(JoinConfig join, Node node) {
        return node.getProperties().getBoolean(ClusterProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED) || AliasedDiscoveryConfigUtils.allUsePublicAddress((List)AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom((JoinConfig)join));
    }
}

