/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.source.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.e2e.source.inmemory.InMemorySourceSplit;
import org.apache.seatunnel.e2e.source.inmemory.InMemoryState;

public class InMemorySourceSplitEnumerator
implements SourceSplitEnumerator<InMemorySourceSplit, InMemoryState> {
    private final SourceSplitEnumerator.Context<InMemorySourceSplit> context;
    private final Object lock = new Object();
    public static final List<String> methodInvoked = new ArrayList<String>();

    public InMemorySourceSplitEnumerator(SourceSplitEnumerator.Context<InMemorySourceSplit> context) {
        this.context = context;
    }

    public static List<String> getMethodInvoked() {
        return methodInvoked;
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        methodInvoked.add("run");
        for (int i = 0; i < this.context.currentParallelism(); ++i) {
            Object object = this.lock;
            synchronized (object) {
                this.context.assignSplit(i, (SourceSplit)new InMemorySourceSplit("split-" + i));
                this.context.signalNoMoreSplits(i);
                continue;
            }
        }
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<InMemorySourceSplit> splits, int subtaskId) {
        methodInvoked.add("addSplitsBack");
    }

    public int currentUnassignedSplitSize() {
        return -1;
    }

    public void registerReader(int subtaskId) {
        methodInvoked.add("registerReader_" + subtaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryState snapshotState(long checkpointId) {
        Object object = this.lock;
        synchronized (object) {
            return new InMemoryState();
        }
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void handleSplitRequest(int subtaskId) {
    }
}

