/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.source.inmemory;

import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.e2e.source.inmemory.InMemorySourceSplit;

public class InMemorySourceReader
implements SourceReader<SeaTunnelRow, InMemorySourceSplit> {
    private final Iterator<SeaTunnelRow> iterator;
    private final SourceReader.Context context;
    private final Deque<InMemorySourceSplit> sourceSplits = new ConcurrentLinkedDeque<InMemorySourceSplit>();
    private volatile boolean noMoreSplit;

    public InMemorySourceReader(List<SeaTunnelRow> rows, SourceReader.Context context) {
        this.iterator = rows.iterator();
        this.context = context;
    }

    public void open() throws Exception {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            InMemorySourceSplit split = this.sourceSplits.poll();
            if (null != split) {
                while (this.iterator.hasNext()) {
                    SeaTunnelRow row = this.iterator.next();
                    output.collect((Object)row);
                }
            } else if (this.noMoreSplit && this.sourceSplits.isEmpty()) {
                this.context.signalNoMoreElement();
            } else {
                Thread.sleep(1000L);
            }
        }
    }

    public List<InMemorySourceSplit> snapshotState(long checkpointId) throws Exception {
        return Collections.emptyList();
    }

    public void addSplits(List<InMemorySourceSplit> splits) {
        this.sourceSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

