/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.sink.inmemory;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryAggregatedCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryAggregatedCommitter;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryCommitInfo;
import org.apache.seatunnel.e2e.sink.inmemory.InMemorySaveModeHandler;
import org.apache.seatunnel.e2e.sink.inmemory.InMemorySinkWriter;
import org.apache.seatunnel.e2e.sink.inmemory.InMemoryState;

public class InMemorySink
implements SeaTunnelSink<SeaTunnelRow, InMemoryState, InMemoryCommitInfo, InMemoryAggregatedCommitInfo>,
SupportMultiTableSink,
SupportSaveMode {
    private ReadonlyConfig config;
    private CatalogTable catalogTable;

    public InMemorySink(CatalogTable catalogTable, ReadonlyConfig config) {
        this.catalogTable = catalogTable;
        this.config = config;
    }

    public String getPluginName() {
        return "InMemorySink";
    }

    public SinkWriter<SeaTunnelRow, InMemoryCommitInfo, InMemoryState> createWriter(SinkWriter.Context context) throws IOException {
        return new InMemorySinkWriter(this.config);
    }

    public Optional<Serializer<InMemoryCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkAggregatedCommitter<InMemoryCommitInfo, InMemoryAggregatedCommitInfo>> createAggregatedCommitter() throws IOException {
        return Optional.of(new InMemoryAggregatedCommitter(this.config));
    }

    public Optional<Serializer<InMemoryAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        return Optional.of(new InMemorySaveModeHandler(this.catalogTable));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

