/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.junit;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.apache.seatunnel.e2e.common.container.ContainerExtendedFactory;
import org.apache.seatunnel.e2e.common.container.TestContainer;
import org.apache.seatunnel.e2e.common.container.TestContainersFactory;
import org.apache.seatunnel.e2e.common.junit.AnnotationUtil;
import org.apache.seatunnel.e2e.common.junit.TestContainerExtension;
import org.apache.seatunnel.e2e.common.junit.TestContainers;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class ContainerTestingExtension
implements BeforeAllCallback,
AfterAllCallback {
    public static final ExtensionContext.Namespace TEST_RESOURCE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testResourceNamespace"});
    public static final String TEST_CONTAINERS_STORE_KEY = "testContainers";
    public static final String TEST_EXTENDED_FACTORY_STORE_KEY = "testContainerExtendedFactory";

    public void beforeAll(ExtensionContext context) throws Exception {
        List containerExtendedFactories = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestContainerExtension.class, ContainerExtendedFactory.class);
        this.checkAtMostOneAnnotationField(containerExtendedFactories, TestContainerExtension.class);
        ContainerExtendedFactory containerExtendedFactory = container -> {};
        if (!containerExtendedFactories.isEmpty()) {
            containerExtendedFactory = (ContainerExtendedFactory)containerExtendedFactories.get(0);
        }
        context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)TEST_EXTENDED_FACTORY_STORE_KEY, (Object)containerExtendedFactory);
        List containersFactories = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestContainers.class, TestContainersFactory.class);
        this.checkExactlyOneAnnotatedField(containersFactories, TestContainers.class);
        List<TestContainer> testContainers = AnnotationUtil.filterDisabledContainers(((TestContainersFactory)containersFactories.get(0)).create(), context.getRequiredTestInstance().getClass());
        context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)TEST_CONTAINERS_STORE_KEY, testContainers);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        context.getStore(TEST_RESOURCE_NAMESPACE).remove((Object)TEST_CONTAINERS_STORE_KEY);
    }

    private void checkExactlyOneAnnotatedField(Collection<?> fields, Class<? extends Annotation> annotation) {
        this.checkAtMostOneAnnotationField(fields, annotation);
        this.checkAtLeastOneAnnotationField(fields, annotation);
    }

    private void checkAtLeastOneAnnotationField(Collection<?> fields, Class<? extends Annotation> annotation) {
        if (fields.isEmpty()) {
            throw new IllegalStateException(String.format("No fields are annotated with '@%s'", annotation.getSimpleName()));
        }
    }

    private void checkAtMostOneAnnotationField(Collection<?> fields, Class<? extends Annotation> annotation) {
        if (fields.size() > 1) {
            throw new IllegalStateException(String.format("Multiple fields are annotated with '@%s'", annotation.getSimpleName()));
        }
    }
}

