/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.container.spark;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.e2e.common.container.AbstractTestContainer;
import org.apache.seatunnel.e2e.common.container.ContainerExtendedFactory;
import org.apache.seatunnel.e2e.common.util.ContainerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerLoggerFactory;

public abstract class AbstractTestSparkContainer
extends AbstractTestContainer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestSparkContainer.class);
    private static final String DEFAULT_DOCKER_IMAGE = "bitnami/spark:2.4.6";
    protected GenericContainer<?> master;

    @Override
    protected String getDockerImage() {
        return DEFAULT_DOCKER_IMAGE;
    }

    @Override
    public void startUp() throws Exception {
        FileUtils.createNewDir((String)HOST_VOLUME_MOUNT_PATH);
        this.master = new GenericContainer(this.getDockerImage()).withNetwork(NETWORK).withNetworkAliases(new String[]{"spark-master"}).withExposedPorts(new Integer[0]).withEnv("SPARK_MODE", "master").withLogConsumer((Consumer)new Slf4jLogConsumer(DockerLoggerFactory.getLogger((String)this.getDockerImage()))).withCreateContainerCmdModifier(cmd -> cmd.withUser("root")).withFileSystemBind(HOST_VOLUME_MOUNT_PATH, "/tmp/seatunnel_mnt", BindMode.READ_WRITE).waitingFor(new LogMessageWaitStrategy().withRegEx(".*Master: Starting Spark master at.*").withStartupTimeout(Duration.ofMinutes(2L)));
        this.copySeaTunnelStarterToContainer(this.master);
        this.copySeaTunnelStarterLoggingToContainer(this.master);
        Startables.deepStart(Stream.of(this.master)).join();
        this.executeExtraCommands(this.master);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.master != null) {
            this.master.execInContainer(new String[]{"rm", "-rf", "/tmp/seatunnel_mnt"});
            this.master.stop();
        }
        FileUtils.deleteFile((String)HOST_VOLUME_MOUNT_PATH);
    }

    @Override
    protected String getSavePointCommand() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected String getCancelJobCommand() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected String getRestoreCommand() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected List<String> getExtraStartShellCommands() {
        return Arrays.asList("--master local", "--deploy-mode client");
    }

    @Override
    public void executeExtraCommands(ContainerExtendedFactory extendedFactory) throws IOException, InterruptedException {
        extendedFactory.extend(this.master);
    }

    @Override
    public Container.ExecResult executeJob(String confFile) throws IOException, InterruptedException {
        return this.executeJob(confFile, Collections.emptyList());
    }

    @Override
    public Container.ExecResult executeJob(String confFile, List<String> variables) throws IOException, InterruptedException {
        log.info("test in container: {}", (Object)this.identifier());
        return this.executeJob(this.master, confFile, null, variables);
    }

    @Override
    public String getServerLogs() {
        return this.master.getLogs();
    }

    @Override
    public void copyFileToContainer(String path, String targetPath) {
        ContainerUtil.copyFileIntoContainers(ContainerUtil.getResourcesFile(path).toPath(), targetPath, this.master);
    }

    @Override
    public void copyAbsolutePathToContainer(String path, String targetPath) {
        ContainerUtil.copyFileIntoContainers(Paths.get(path, new String[0]), targetPath, this.master);
    }
}

