/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.e2e.common.container;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.e2e.common.container.TestContainer;
import org.apache.seatunnel.e2e.common.util.ContainerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public abstract class AbstractTestContainer
implements TestContainer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTestContainer.class);
    protected static final String START_ROOT_MODULE_NAME = "seatunnel-core";
    public static final String SEATUNNEL_HOME = "/tmp/seatunnel/";
    protected static final boolean isWindows = System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS");
    protected static String hostName = System.getProperty("user.name");
    protected Integer hostUid = Integer.parseInt(System.getProperty("user.id", "1000"));
    protected Integer hostGid = Integer.parseInt(System.getProperty("user.gid", "1000"));
    protected static final String CONTAINER_VOLUME_MOUNT_PATH = "/tmp/seatunnel_mnt";
    public static final String HOST_VOLUME_MOUNT_PATH = isWindows ? String.format("C:/Users/%s/tmp/seatunnel_mnt", hostName) : "/tmp/seatunnel_mnt";
    protected final String startModuleName = this.getStartModuleName();
    protected final String startModuleFullPath = ContainerUtil.PROJECT_ROOT_PATH + File.separator + "seatunnel-core" + File.separator + this.startModuleName;

    public AbstractTestContainer() {
        ContainerUtil.checkPathExist(this.startModuleFullPath);
    }

    protected abstract String getDockerImage();

    protected abstract String getStartModuleName();

    protected abstract String getStartShellName();

    protected abstract String getConnectorModulePath();

    protected abstract String getConnectorType();

    protected abstract String getSavePointCommand();

    protected abstract String getCancelJobCommand();

    protected abstract String getRestoreCommand();

    protected abstract String getConnectorNamePrefix();

    protected abstract List<String> getExtraStartShellCommands();

    protected void executeExtraCommands(GenericContainer<?> container) throws IOException, InterruptedException {
    }

    protected void copySeaTunnelStarterToContainer(GenericContainer<?> container) {
        ContainerUtil.copySeaTunnelStarterToContainer(container, this.startModuleName, this.startModuleFullPath, SEATUNNEL_HOME);
    }

    protected void copySeaTunnelStarterLoggingToContainer(GenericContainer<?> container) {
        ContainerUtil.copySeaTunnelStarterLoggingToContainer(container, this.startModuleFullPath, SEATUNNEL_HOME);
    }

    protected Container.ExecResult executeJob(GenericContainer<?> container, String confFile) throws IOException, InterruptedException {
        return this.executeJob(container, confFile, null, null);
    }

    protected Container.ExecResult executeJob(GenericContainer<?> container, String confFile, String jobId, List<String> variables) throws IOException, InterruptedException {
        String confInContainerPath = ContainerUtil.copyConfigFileToContainer(container, confFile);
        ContainerUtil.copyConnectorJarToContainer(container, confFile, this.getConnectorModulePath(), this.getConnectorNamePrefix(), this.getConnectorType(), SEATUNNEL_HOME);
        ArrayList<String> command = new ArrayList<String>();
        String binPath = Paths.get(SEATUNNEL_HOME, "bin", this.getStartShellName()).toString();
        command.add(ContainerUtil.adaptPathForWin(binPath));
        command.add("--config");
        command.add(ContainerUtil.adaptPathForWin(confInContainerPath));
        command.add("--name");
        command.add(new File(confInContainerPath).getName());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jobId})) {
            command.add("--set-job-id");
            command.add(jobId);
        }
        ArrayList<String> extraStartShellCommands = new ArrayList<String>(this.getExtraStartShellCommands());
        if (variables != null && !variables.isEmpty()) {
            variables.forEach(v -> {
                extraStartShellCommands.add("-i");
                extraStartShellCommands.add((String)v);
            });
        }
        command.addAll(extraStartShellCommands);
        return this.executeCommand(container, command);
    }

    protected Container.ExecResult savepointJob(GenericContainer<?> container, String jobId) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        String binPath = Paths.get(SEATUNNEL_HOME, "bin", this.getStartShellName()).toString();
        command.add(ContainerUtil.adaptPathForWin(binPath));
        command.add(this.getSavePointCommand());
        command.add(jobId);
        command.addAll(this.getExtraStartShellCommands());
        return this.executeCommand(container, command);
    }

    protected Container.ExecResult cancelJob(GenericContainer<?> container, String jobId) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        String binPath = Paths.get(SEATUNNEL_HOME, "bin", this.getStartShellName()).toString();
        command.add(ContainerUtil.adaptPathForWin(binPath));
        command.add(this.getCancelJobCommand());
        command.add(jobId);
        command.addAll(this.getExtraStartShellCommands());
        return this.executeCommand(container, command);
    }

    protected Container.ExecResult restoreJob(GenericContainer<?> container, String confFile, String jobId, List<String> variables) throws IOException, InterruptedException {
        String confInContainerPath = ContainerUtil.copyConfigFileToContainer(container, confFile);
        ContainerUtil.copyConnectorJarToContainer(container, confFile, this.getConnectorModulePath(), this.getConnectorNamePrefix(), this.getConnectorType(), SEATUNNEL_HOME);
        ArrayList<String> command = new ArrayList<String>();
        String binPath = Paths.get(SEATUNNEL_HOME, "bin", this.getStartShellName()).toString();
        command.add(ContainerUtil.adaptPathForWin(binPath));
        command.add("--config");
        command.add(ContainerUtil.adaptPathForWin(confInContainerPath));
        command.add(this.getRestoreCommand());
        command.add(jobId);
        ArrayList<String> extraStartShellCommands = new ArrayList<String>(this.getExtraStartShellCommands());
        if (variables != null && !variables.isEmpty()) {
            variables.forEach(v -> {
                extraStartShellCommands.add("-i");
                extraStartShellCommands.add((String)v);
            });
        }
        command.addAll(extraStartShellCommands);
        return this.executeCommand(container, command);
    }

    protected Container.ExecResult executeCommand(GenericContainer<?> container, List<String> command) throws IOException, InterruptedException {
        String commandStr = String.join((CharSequence)" ", command);
        LOG.info("Execute command in container[{}] \n==================== Shell Command start ====================\n{}\n==================== Shell Command end   ====================", (Object)container.getDockerImageName(), (Object)commandStr);
        Container.ExecResult execResult = container.execInContainer(new String[]{"bash", "-c", commandStr});
        if (execResult.getStdout() != null && !execResult.getStdout().isEmpty()) {
            LOG.info("Container[{}] command {} STDOUT:\n==================== STDOUT start ====================\n{}\n==================== STDOUT end   ====================", new Object[]{container.getDockerImageName(), commandStr, execResult.getStdout()});
        }
        if (execResult.getStderr() != null && !execResult.getStderr().isEmpty()) {
            LOG.error("Container[{}] command {} STDERR:\n==================== STDERR start ====================\n{}\n==================== STDERR end   ====================", new Object[]{container.getDockerImageName(), commandStr, execResult.getStderr()});
        }
        if (execResult.getExitCode() != 0) {
            LOG.info("Container[{}] command {} Server Log:\n==================== Server Log start ====================\n{}\n==================== Server Log end   ====================", new Object[]{container.getDockerImageName(), commandStr, container.getLogs()});
        }
        return execResult;
    }
}

