/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum DeployMode {
    CLIENT("client"),
    CLUSTER("cluster");

    private static final Map<String, DeployMode> NAME_MAP;
    private final String name;

    private DeployMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<DeployMode> from(String name) {
        return Optional.ofNullable(NAME_MAP.get(name));
    }

    static {
        NAME_MAP = Arrays.stream(DeployMode.values()).collect(HashMap::new, (map2, deployMode) -> map2.put(deployMode.getName(), deployMode), Map::putAll);
    }
}

