/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.spark.DefaultHelper;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.MongoConnector$;
import com.mongodb.spark.MongoSpark;
import com.mongodb.spark.MongoSpark$;
import com.mongodb.spark.MongoSpark$$anonfun$save$3$;
import com.mongodb.spark.MongoSpark$$anonfun$save$3$$anonfun$apply$3$;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import com.mongodb.spark.config.WriteConfig;
import com.mongodb.spark.config.WriteConfig$;
import com.mongodb.spark.package$;
import com.mongodb.spark.rdd.MongoRDD;
import com.mongodb.spark.rdd.api.java.JavaMongoRDD;
import com.mongodb.spark.sql.MapFunctions$;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;

public final class MongoSpark$
implements Serializable {
    public static final MongoSpark$ MODULE$;
    private final String defaultSource;

    static {
        new MongoSpark$();
    }

    public String defaultSource() {
        return this.defaultSource;
    }

    public MongoSpark.Builder builder() {
        return new MongoSpark.Builder();
    }

    public <D> MongoRDD<D> load(SparkContext sc, ClassTag<D> evidence$1, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.load(sc, (ReadConfig)ReadConfig$.MODULE$.apply(sc), evidence$1, e);
    }

    public <D> MongoRDD<D> load(SparkContext sc, ReadConfig readConfig, ClassTag<D> evidence$2, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.builder().sparkContext(sc).readConfig(readConfig).build().toRDD(evidence$2, e);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, TypeTags.TypeTag<D> evidence$3) {
        return this.builder().sparkSession(sparkSession).build().toDF(evidence$3);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$4) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(evidence$4);
    }

    public <D> void save(RDD<D> rdd, ClassTag<D> evidence$5) {
        this.save(rdd, (WriteConfig)WriteConfig$.MODULE$.apply(rdd.sparkContext()), evidence$5);
    }

    public <D> void save(RDD<D> rdd, WriteConfig writeConfig, ClassTag<D> evidence$6) {
        MongoConnector mongoConnector = MongoConnector$.MODULE$.apply(writeConfig.asOptions());
        rdd.foreachPartition((Function1)((Object)new Serializable(writeConfig, evidence$6, mongoConnector){
            public static final long serialVersionUID = 0L;
            public final WriteConfig writeConfig$2;
            private final ClassTag evidence$6$1;
            private final MongoConnector mongoConnector$1;

            public final void apply(Iterator<D> iter2) {
                if (iter2.nonEmpty()) {
                    this.mongoConnector$1.withCollectionDo((MongoCollectionConfig)this.writeConfig$2, new Serializable(this, iter2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.save.1 $outer;
                        private final Iterator iter$1;

                        public final void apply(MongoCollection<D> collection) {
                            this.iter$1.grouped(this.$outer.writeConfig$2.maxBatchSize()).foreach(new Serializable(this, collection){
                                public static final long serialVersionUID = 0L;
                                private final MongoCollection collection$1;

                                public final void apply(Seq<D> batch) {
                                    this.collection$1.insertMany(JavaConverters$.MODULE$.seqAsJavaListConverter(batch.toList()).asJava());
                                }
                                {
                                    this.collection$1 = collection$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.iter$1 = iter$1;
                        }
                    }, this.evidence$6$1);
                }
            }
            {
                this.writeConfig$2 = writeConfig$2;
                this.evidence$6$1 = evidence$6$1;
                this.mongoConnector$1 = mongoConnector$1;
            }
        }));
    }

    public <D> void save(Dataset<D> dataset) {
        this.save(dataset, (WriteConfig)WriteConfig$.MODULE$.apply(dataset.sparkSession().sparkContext().getConf()));
    }

    public <D> void save(Dataset<D> dataset, WriteConfig writeConfig) {
        MongoConnector mongoConnector = MongoConnector$.MODULE$.apply(writeConfig.asOptions());
        RDD documentRdd = dataset.toDF().rdd().map((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonDocument apply(Row row) {
                return MapFunctions$.MODULE$.rowToDocument(row);
            }
        }), ClassTag$.MODULE$.apply(BsonDocument.class));
        if (Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields()).exists(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$1) {
                String string2 = x$1.name();
                String string3 = "_id";
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
        })) {
            documentRdd.foreachPartition((Function1)((Object)new Serializable(writeConfig, mongoConnector){
                public static final long serialVersionUID = 0L;
                public final WriteConfig writeConfig$1;
                private final MongoConnector mongoConnector$2;

                public final void apply(Iterator<BsonDocument> iter2) {
                    if (iter2.nonEmpty()) {
                        this.mongoConnector$2.withCollectionDo((MongoCollectionConfig)this.writeConfig$1, new Serializable(this, iter2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.save.3 $outer;
                            private final Iterator iter$2;

                            public final void apply(MongoCollection<BsonDocument> collection) {
                                this.iter$2.grouped(this.$outer.writeConfig$1.maxBatchSize()).foreach(new Serializable(this, collection){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$save$3$$anonfun$apply$3 $outer;
                                    private final MongoCollection collection$2;

                                    public final BulkWriteResult apply(Seq<BsonDocument> batch) {
                                        UpdateOptions updateOptions = new UpdateOptions().upsert(true);
                                        Seq<A> requests = batch.map(new Serializable(this, updateOptions){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$save$3$$anonfun$apply$3$$anonfun$apply$4 $outer;
                                            private final UpdateOptions updateOptions$1;

                                            public final WriteModel<BsonDocument> apply(BsonDocument doc) {
                                                Option<BsonValue> option;
                                                block7: {
                                                    WriteModel writeModel;
                                                    block6: {
                                                        block5: {
                                                            WriteModel writeModel2;
                                                            option = Option$.MODULE$.apply(doc.get("_id"));
                                                            if (!(option instanceof Some)) break block5;
                                                            Some some = (Some)option;
                                                            BsonValue _id = (BsonValue)some.x();
                                                            if (this.$outer.com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer().com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer().writeConfig$1.replaceDocument()) {
                                                                writeModel2 = new ReplaceOneModel<BsonDocument>(new BsonDocument("_id", _id), doc, this.updateOptions$1);
                                                            } else {
                                                                doc.remove("_id");
                                                                writeModel2 = new UpdateOneModel<T>(new BsonDocument("_id", _id), new BsonDocument("$set", doc), this.updateOptions$1);
                                                            }
                                                            writeModel = writeModel2;
                                                            break block6;
                                                        }
                                                        if (!None$.MODULE$.equals(option)) break block7;
                                                        writeModel = new InsertOneModel<BsonDocument>(doc);
                                                    }
                                                    return writeModel;
                                                }
                                                throw new MatchError(option);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.updateOptions$1 = updateOptions$1;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        return this.collection$2.bulkWrite(JavaConverters$.MODULE$.seqAsJavaListConverter(requests.toList()).asJava());
                                    }

                                    public /* synthetic */ anonfun$save$3$$anonfun$apply$3 com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.collection$2 = collection$2;
                                    }
                                });
                            }

                            public /* synthetic */ anonfun.save.3 com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.iter$2 = iter$2;
                            }
                        }, ClassTag$.MODULE$.apply(BsonDocument.class));
                    }
                }
                {
                    this.writeConfig$1 = writeConfig$1;
                    this.mongoConnector$2 = mongoConnector$2;
                }
            }));
        } else {
            this.save(documentRdd, writeConfig, ClassTag$.MODULE$.apply(BsonDocument.class));
        }
    }

    public void save(DataFrameWriter<?> dataFrameWriter) {
        dataFrameWriter.format(this.defaultSource()).save();
    }

    public void save(DataFrameWriter<?> dataFrameWriter, WriteConfig writeConfig) {
        dataFrameWriter.format(this.defaultSource()).options(writeConfig.asOptions()).save();
    }

    public DataFrameReader read(SparkSession sparkSession) {
        return sparkSession.read().format("com.mongodb.spark.sql");
    }

    public <T> DataFrameWriter<T> write(Dataset<T> dataset) {
        return dataset.write().format("com.mongodb.spark.sql");
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD();
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc, ReadConfig readConfig) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD();
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD(clazz);
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD(clazz);
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession) {
        return this.builder().sparkSession(sparkSession).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession, ReadConfig readConfig) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public <D> Dataset<D> load(SparkSession sparkSession, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).build().toDS(clazz);
    }

    public <D> Dataset<D> load(SparkSession sparkSession, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDS(clazz);
    }

    public void save(JavaRDD<Document> javaRDD) {
        this.save(javaRDD, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        this.save(javaRDD.rdd(), this.ct$1(clazz));
    }

    public void save(JavaRDD<Document> javaRDD, WriteConfig writeConfig) {
        this.save(javaRDD, writeConfig, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, WriteConfig writeConfig, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        package$.MODULE$.notNull("writeConfig", writeConfig);
        this.save(javaRDD.rdd(), writeConfig, this.ct$2(clazz));
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, TypeTags.TypeTag<D> evidence$7) {
        return this.load(sqlContext.sparkSession(), evidence$7);
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$8) {
        return this.load(sqlContext.sparkSession(), readConfig, evidence$8);
    }

    public <D> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sqlContext.sparkSession()).readConfig(readConfig).build().toDF(clazz);
    }

    public DataFrameReader read(SQLContext sqlContext) {
        return this.read(sqlContext.sparkSession());
    }

    public MongoSpark apply(SparkSession sparkSession, MongoConnector connector, ReadConfig readConfig, Seq<BsonDocument> pipeline) {
        return new MongoSpark(sparkSession, connector, readConfig, pipeline);
    }

    public Option<Tuple4<SparkSession, MongoConnector, ReadConfig, Seq<BsonDocument>>> unapply(MongoSpark x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple4<SparkSession, MongoConnector, ReadConfig, Seq<BsonDocument>>>(new Tuple4<SparkSession, MongoConnector, ReadConfig, Seq<BsonDocument>>(x$0.sparkSession(), x$0.connector(), x$0.readConfig(), x$0.pipeline()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final ClassTag ct$1(Class clazz$2) {
        return ClassTag$.MODULE$.apply(clazz$2);
    }

    private final ClassTag ct$2(Class clazz$1) {
        return ClassTag$.MODULE$.apply(clazz$1);
    }

    private MongoSpark$() {
        MODULE$ = this;
        this.defaultSource = "com.mongodb.spark.sql.DefaultSource";
    }
}

