/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import org.bson.BsonDocument;

final class WriteConcernHelper {
    static void appendWriteConcernToCommand(WriteConcern writeConcern2, BsonDocument commandDocument, ConnectionDescription description) {
        if (writeConcern2 != null && !writeConcern2.isServerDefault() && OperationHelper.serverIsAtLeastVersionThreeDotFour(description)) {
            commandDocument.put("writeConcern", writeConcern2.asDocument());
        }
    }

    static CommandOperationHelper.CommandTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, Void>(){

            @Override
            public Void apply(BsonDocument result2, ServerAddress serverAddress) {
                WriteConcernHelper.throwOnWriteConcernError(result2, serverAddress);
                return null;
            }
        };
    }

    static void throwOnWriteConcernError(BsonDocument result2, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result2)) {
            throw WriteConcernHelper.createWriteConcernError(result2, serverAddress);
        }
    }

    static boolean hasWriteConcernError(BsonDocument result2) {
        return result2.containsKey("writeConcernError");
    }

    static MongoWriteConcernException createWriteConcernError(BsonDocument result2, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result2.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
    }

    static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

