/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.operation.BaseWriteOperation;
import java.util.List;

public class InsertOperation
extends BaseWriteOperation {
    private final List<InsertRequest> insertRequests;

    public InsertOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern2, List<InsertRequest> insertRequests) {
        super(namespace, ordered, writeConcern2);
        this.insertRequests = Assertions.notNull("insertRequests", insertRequests);
    }

    public List<InsertRequest> getInsertRequests() {
        return this.insertRequests;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        return connection.insert(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.insertRequests);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        connection.insertAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.insertRequests, callback);
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        return connection.insertCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.insertRequests);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        connection.insertCommandAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.insertRequests, callback);
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.INSERT;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return 0;
    }
}

