/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.connection.BaseWriteCommandMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

class InsertCommandMessage
extends BaseWriteCommandMessage {
    private final List<InsertRequest> insertRequestList;

    public InsertCommandMessage(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern2, Boolean bypassDocumentValidation, MessageSettings settings, List<InsertRequest> insertRequestList) {
        super(namespace, ordered, writeConcern2, bypassDocumentValidation, settings);
        this.insertRequestList = Assertions.notNull("insertRequestList", insertRequestList);
    }

    @Override
    public int getItemCount() {
        return this.insertRequestList.size();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> map2 = new HashMap<String, FieldNameValidator>();
        map2.put("documents", new CollectibleDocumentFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map2);
    }

    public List<InsertRequest> getRequests() {
        return Collections.unmodifiableList(this.insertRequestList);
    }

    @Override
    protected String getCommandName() {
        return "insert";
    }

    @Override
    protected InsertCommandMessage writeTheWrites(BsonOutput bsonOutput, int commandStartPosition, BsonBinaryWriter writer) {
        InsertCommandMessage nextMessage = null;
        writer.writeStartArray("documents");
        writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
        for (int i = 0; i < this.insertRequestList.size(); ++i) {
            writer.mark();
            BsonDocument document = this.insertRequestList.get(i).getDocument();
            this.getCodec(document).encode(writer, document, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
            if (!this.exceedsLimits(bsonOutput.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new InsertCommandMessage(this.getWriteNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.getSettings(), this.insertRequestList.subList(i, this.insertRequestList.size()));
            break;
        }
        writer.popMaxDocumentSize();
        writer.writeEndArray();
        return nextMessage;
    }
}

