/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.transport.netty4.ByteBufBytesReference;
import org.elasticsearch.transport.netty4.Netty4InternalESLogger;

public class Netty4Utils {
    private static AtomicBoolean isAvailableProcessorsSet;

    public static void setup() {
    }

    public static void setAvailableProcessors(int availableProcessors) {
        boolean set = Booleans.parseBoolean(System.getProperty("es.set.netty.runtime.available.processors", "true"));
        if (!set) {
            return;
        }
        if (isAvailableProcessorsSet.compareAndSet(false, true)) {
            NettyRuntime.setAvailableProcessors(availableProcessors);
        } else if (availableProcessors != NettyRuntime.availableProcessors()) {
            String message = String.format(Locale.ROOT, "available processors value [%d] did not match current value [%d]", availableProcessors, NettyRuntime.availableProcessors());
            throw new IllegalStateException(message);
        }
    }

    public static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (reference instanceof ByteBufBytesReference) {
            return ((ByteBufBytesReference)reference).toByteBuf();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer(slice.bytes, slice.offset, slice.length));
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer(buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ByteBuf buffer) {
        return Netty4Utils.toBytesReference(buffer, buffer.readableBytes());
    }

    static BytesReference toBytesReference(ByteBuf buffer, int size) {
        return new ByteBufBytesReference(buffer, size);
    }

    public static void closeChannels(Collection<Channel> channels) throws IOException {
        Throwable closingExceptions = null;
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (Channel channel : channels) {
            try {
                if (channel == null || !channel.isOpen()) continue;
                futures.add(channel.close());
            }
            catch (Exception e) {
                if (closingExceptions == null) {
                    closingExceptions = new IOException("failed to close channels");
                }
                closingExceptions.addSuppressed(e);
            }
        }
        for (ChannelFuture future : futures) {
            future.awaitUninterruptibly();
        }
        if (closingExceptions != null) {
            throw closingExceptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maybeDie(Throwable cause) {
        Logger logger = ESLoggerFactory.getLogger(Netty4Utils.class);
        Optional<Error> maybeError = ExceptionsHelper.maybeError(cause, logger);
        if (maybeError.isPresent()) {
            try {
                String formatted = ExceptionsHelper.formatStackTrace(Thread.currentThread().getStackTrace());
                logger.error("fatal error on the network layer\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw (Error)maybeError.get();
                }).start();
            }
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new InternalLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return new Netty4InternalESLogger(name);
            }
        });
        isAvailableProcessorsSet = new AtomicBoolean();
    }
}

