/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

class ByteBufStreamInput
extends StreamInput {
    private final ByteBuf buffer;
    private final int endIndex;

    ByteBufStreamInput(ByteBuf buffer, int length) {
        if (length > buffer.readableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = buffer;
        int startIndex = buffer.readerIndex();
        this.endIndex = startIndex + length;
        buffer.markReaderIndex();
    }

    @Override
    public BytesReference readBytesReference(int length) throws IOException {
        return super.readBytesReference(length);
    }

    @Override
    public BytesRef readBytesRef(int length) throws IOException {
        return super.readBytesRef(length);
    }

    @Override
    public int available() throws IOException {
        return this.endIndex - this.buffer.readerIndex();
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        int bytesAvailable = this.endIndex - this.buffer.readerIndex();
        if (bytesAvailable < length) {
            throw new EOFException("tried to read: " + length + " bytes but only " + bytesAvailable + " remaining");
        }
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)n);
    }

    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int read = this.read(b, offset, len);
        if (read < len) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

