/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DataFormatException;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

abstract class AbstractInternalHDRPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected final double[] keys;
    protected final DoubleHistogram state;
    protected final boolean keyed;

    AbstractInternalHDRPercentiles(String name, double[] keys, DoubleHistogram state, boolean keyed, DocValueFormat format, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
        this.format = format;
    }

    protected AbstractInternalHDRPercentiles(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keys = in.readDoubleArray();
        long minBarForHighestToLowestValueRatio = in.readLong();
        int serializedLen = in.readVInt();
        byte[] bytes = new byte[serializedLen];
        in.readBytes(bytes, 0, serializedLen);
        ByteBuffer stateBuffer = ByteBuffer.wrap(bytes);
        try {
            this.state = DoubleHistogram.decodeFromCompressedByteBuffer(stateBuffer, minBarForHighestToLowestValueRatio);
        }
        catch (DataFormatException e) {
            throw new IOException("Failed to decode DoubleHistogram for aggregation [" + this.name + "]", e);
        }
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.keys);
        out.writeLong(this.state.getHighestToLowestValueRatio());
        ByteBuffer stateBuffer = ByteBuffer.allocate(this.state.getNeededByteBufferCapacity());
        int serializedLen = this.state.encodeIntoCompressedByteBuffer(stateBuffer);
        out.writeVInt(serializedLen);
        out.writeBytes(stateBuffer.array(), 0, serializedLen);
        out.writeBoolean(this.keyed);
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    DocValueFormat formatter() {
        return this.format;
    }

    public abstract double value(double var1);

    public long getEstimatedMemoryFootprint() {
        return this.state.getEstimatedFootprintInBytes();
    }

    @Override
    public AbstractInternalHDRPercentiles doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        DoubleHistogram merged = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalHDRPercentiles percentiles = (AbstractInternalHDRPercentiles)aggregation;
            if (merged == null) {
                merged = new DoubleHistogram(percentiles.state);
                merged.setAutoResize(true);
            }
            merged.add(percentiles.state);
        }
        return this.createReduced(this.getName(), this.keys, merged, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    protected abstract AbstractInternalHDRPercentiles createReduced(String var1, double[] var2, DoubleHistogram var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                String key = String.valueOf(this.keys[i]);
                double value = this.value(this.keys[i]);
                builder.field(key, value);
                if (this.format == DocValueFormat.RAW) continue;
                builder.field(key + "_as_string", this.format.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                double value = this.value(this.keys[i]);
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.keys[i]);
                builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), value);
                if (this.format != DocValueFormat.RAW) {
                    builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    protected boolean doEquals(Object obj) {
        AbstractInternalHDRPercentiles that = (AbstractInternalHDRPercentiles)obj;
        return this.keyed == that.keyed && Arrays.equals(this.keys, that.keys) && Objects.equals(this.state, that.state);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.keyed, Arrays.hashCode(this.keys), this.state.getIntegerToDoubleValueConversionRatio(), this.state.getTotalCount());
    }
}

