/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.elasticsearch.Version;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.PercolatorHighlightSubFetchPhase;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

final class PercolatorMatchedSlotSubFetchPhase
implements FetchSubPhase {
    static final String FIELD_NAME_PREFIX = "_percolator_document_slot";

    PercolatorMatchedSlotSubFetchPhase() {
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        PercolatorMatchedSlotSubFetchPhase.innerHitsExecute(context.query(), context.searcher(), hits);
    }

    static void innerHitsExecute(Query mainQuery, IndexSearcher indexSearcher, SearchHit[] hits) throws IOException {
        List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(mainQuery);
        if (percolateQueries.isEmpty()) {
            return;
        }
        boolean singlePercolateQuery = percolateQueries.size() == 1;
        for (PercolateQuery percolateQuery : percolateQueries) {
            boolean hasNestedDocs;
            String fieldName = singlePercolateQuery ? FIELD_NAME_PREFIX : "_percolator_document_slot_" + percolateQuery.getName();
            IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
            Version version = Version.V_6_0_0;
            Weight weight = percolatorIndexSearcher.createNormalizedWeight(Queries.newNonNestedFilter(version), false);
            Scorer s = weight.scorer(percolatorIndexSearcher.getIndexReader().leaves().get(0));
            int memoryIndexMaxDoc = percolatorIndexSearcher.getIndexReader().maxDoc();
            BitSet rootDocs = BitSet.of(s.iterator(), memoryIndexMaxDoc);
            int[] rootDocsBySlot = null;
            boolean bl = hasNestedDocs = rootDocs.cardinality() != percolatorIndexSearcher.getIndexReader().numDocs();
            if (hasNestedDocs) {
                rootDocsBySlot = PercolatorMatchedSlotSubFetchPhase.buildRootDocsSlots(rootDocs);
            }
            PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
            List<LeafReaderContext> ctxs = indexSearcher.getIndexReader().leaves();
            for (SearchHit hit : hits) {
                LeafReaderContext ctx = ctxs.get(ReaderUtil.subIndex(hit.docId(), ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                Query query = queryStore.getQueries(ctx).apply(segmentDocId);
                if (query == null) continue;
                TopFieldDocs topDocs = percolatorIndexSearcher.search(query, memoryIndexMaxDoc, new Sort(SortField.FIELD_DOC));
                if (topDocs.totalHits == 0L) continue;
                Map<String, DocumentField> fields = hit.fieldsOrNull();
                if (fields == null) {
                    fields = new HashMap<String, DocumentField>();
                    hit.fields(fields);
                }
                IntStream slots = PercolatorMatchedSlotSubFetchPhase.convertTopDocsToSlots(topDocs, rootDocsBySlot);
                fields.put(fieldName, new DocumentField(fieldName, slots.boxed().collect(Collectors.toList())));
            }
        }
    }

    static IntStream convertTopDocsToSlots(TopDocs topDocs, int[] rootDocsBySlot) {
        IntStream stream = Arrays.stream(topDocs.scoreDocs).mapToInt(scoreDoc -> scoreDoc.doc);
        if (rootDocsBySlot != null) {
            stream = stream.map(docId -> Arrays.binarySearch(rootDocsBySlot, docId));
        }
        return stream;
    }

    static int[] buildRootDocsSlots(BitSet rootDocs) {
        int slot = 0;
        int[] rootDocsBySlot = new int[rootDocs.cardinality()];
        BitSetIterator iterator = new BitSetIterator(rootDocs, 0L);
        int rootDocId = iterator.nextDoc();
        while (rootDocId != Integer.MAX_VALUE) {
            rootDocsBySlot[slot++] = rootDocId;
            rootDocId = iterator.nextDoc();
        }
        return rootDocsBySlot;
    }
}

