/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CoveringQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.QueryAnalyzer;

public class PercolatorFieldMapper
extends FieldMapper {
    static final XContentType QUERY_BUILDER_CONTENT_TYPE = XContentType.SMILE;
    @Deprecated
    static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING = Setting.boolSetting("index.percolator.map_unmapped_fields_as_string", false, Setting.Property.IndexScope, Setting.Property.Deprecated);
    static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING = Setting.boolSetting("index.percolator.map_unmapped_fields_as_text", false, Setting.Property.IndexScope);
    static final String CONTENT_TYPE = "percolator";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(PercolatorFieldMapper.class));
    private static final FieldType FIELD_TYPE = new FieldType();
    static final byte FIELD_VALUE_SEPARATOR = 0;
    static final String EXTRACTION_COMPLETE = "complete";
    static final String EXTRACTION_PARTIAL = "partial";
    static final String EXTRACTION_FAILED = "failed";
    static final String EXTRACTED_TERMS_FIELD_NAME = "extracted_terms";
    static final String EXTRACTION_RESULT_FIELD_NAME = "extraction_result";
    static final String QUERY_BUILDER_FIELD_NAME = "query_builder_field";
    static final String RANGE_FIELD_NAME = "range_field";
    static final String MINIMUM_SHOULD_MATCH_FIELD_NAME = "minimum_should_match_field";
    private final boolean mapUnmappedFieldAsText;
    private final Supplier<QueryShardContext> queryShardContext;
    private KeywordFieldMapper queryTermsField;
    private KeywordFieldMapper extractionResultField;
    private BinaryFieldMapper queryBuilderField;
    private NumberFieldMapper minimumShouldMatchFieldMapper;
    private RangeFieldMapper rangeFieldMapper;

    PercolatorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Supplier<QueryShardContext> queryShardContext, KeywordFieldMapper queryTermsField, KeywordFieldMapper extractionResultField, BinaryFieldMapper queryBuilderField, RangeFieldMapper rangeFieldMapper, NumberFieldMapper minimumShouldMatchFieldMapper) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.queryShardContext = queryShardContext;
        this.queryTermsField = queryTermsField;
        this.extractionResultField = extractionResultField;
        this.queryBuilderField = queryBuilderField;
        this.minimumShouldMatchFieldMapper = minimumShouldMatchFieldMapper;
        this.mapUnmappedFieldAsText = PercolatorFieldMapper.getMapUnmappedFieldAsText(indexSettings);
        this.rangeFieldMapper = rangeFieldMapper;
    }

    private static boolean getMapUnmappedFieldAsText(Settings indexSettings) {
        if (INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.exists(indexSettings) && INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.exists(indexSettings)) {
            throw new IllegalArgumentException("Either specify [" + INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.getKey() + "] or [" + INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.getKey() + "] setting, not both");
        }
        if (INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.exists(indexSettings)) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog(INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.getKey(), "The [" + INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.getKey() + "] setting is deprecated in favour for the [" + INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.getKey() + "] setting", new Object[0]);
            return INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.get(indexSettings);
        }
        return INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.get(indexSettings);
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        PercolatorFieldMapper updated = (PercolatorFieldMapper)super.updateFieldType((Map)fullNameToFieldType);
        KeywordFieldMapper queryTermsUpdated = (KeywordFieldMapper)this.queryTermsField.updateFieldType((Map)fullNameToFieldType);
        KeywordFieldMapper extractionResultUpdated = (KeywordFieldMapper)this.extractionResultField.updateFieldType((Map)fullNameToFieldType);
        BinaryFieldMapper queryBuilderUpdated = (BinaryFieldMapper)this.queryBuilderField.updateFieldType((Map)fullNameToFieldType);
        RangeFieldMapper rangeFieldMapperUpdated = (RangeFieldMapper)this.rangeFieldMapper.updateFieldType((Map)fullNameToFieldType);
        NumberFieldMapper msmFieldMapperUpdated = (NumberFieldMapper)this.minimumShouldMatchFieldMapper.updateFieldType((Map)fullNameToFieldType);
        if (updated == this && queryTermsUpdated == this.queryTermsField && extractionResultUpdated == this.extractionResultField && queryBuilderUpdated == this.queryBuilderField && rangeFieldMapperUpdated == this.rangeFieldMapper) {
            return this;
        }
        if (updated == this) {
            updated = (PercolatorFieldMapper)updated.clone();
        }
        updated.queryTermsField = queryTermsUpdated;
        updated.extractionResultField = extractionResultUpdated;
        updated.queryBuilderField = queryBuilderUpdated;
        updated.rangeFieldMapper = rangeFieldMapperUpdated;
        updated.minimumShouldMatchFieldMapper = msmFieldMapperUpdated;
        return updated;
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        QueryShardContext queryShardContext = this.queryShardContext.get();
        if (context.doc().getField(this.queryBuilderField.name()) != null) {
            throw new IllegalArgumentException("a document can only contain one percolator query");
        }
        XContentParser parser = context.parser();
        QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation());
        PercolatorFieldMapper.verifyQuery(queryBuilder);
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch(queryBuilder, queryShardContext, future);
        queryBuilder = (QueryBuilder)future.actionGet();
        Version indexVersion = context.mapperService().getIndexSettings().getIndexVersionCreated();
        PercolatorFieldMapper.createQueryBuilderField(indexVersion, this.queryBuilderField, queryBuilder, context);
        Query query = PercolatorFieldMapper.toQuery(queryShardContext, this.mapUnmappedFieldAsText, queryBuilder);
        this.processQuery(query, context);
        return null;
    }

    static void createQueryBuilderField(Version indexVersion, BinaryFieldMapper qbField, QueryBuilder queryBuilder, ParseContext context) throws IOException {
        block17: {
            if (indexVersion.onOrAfter(Version.V_6_0_0_beta2)) {
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
                     OutputStreamStreamOutput out = new OutputStreamStreamOutput(stream);){
                    out.setVersion(indexVersion);
                    out.writeNamedWriteable(queryBuilder);
                    byte[] queryBuilderAsBytes = stream.toByteArray();
                    qbField.parse(context.createExternalValueContext(queryBuilderAsBytes));
                    break block17;
                }
            }
            try (XContentBuilder builder = XContentFactory.contentBuilder(QUERY_BUILDER_CONTENT_TYPE);){
                queryBuilder.toXContent(builder, new ToXContent.MapParams(Collections.emptyMap()));
                builder.flush();
                byte[] queryBuilderAsBytes = BytesReference.toBytes(BytesReference.bytes(builder));
                context.doc().add(new Field(qbField.name(), queryBuilderAsBytes, (IndexableFieldType)qbField.fieldType()));
            }
        }
    }

    void processQuery(Query query, ParseContext context) {
        QueryAnalyzer.Result result;
        ParseContext.Document doc = context.doc();
        FieldType pft = (FieldType)this.fieldType();
        try {
            Version indexVersion = context.mapperService().getIndexSettings().getIndexVersionCreated();
            result = QueryAnalyzer.analyze(query, indexVersion);
        }
        catch (QueryAnalyzer.UnsupportedQueryException e) {
            doc.add(new Field(pft.extractionResultField.name(), EXTRACTION_FAILED, (IndexableFieldType)this.extractionResultField.fieldType()));
            return;
        }
        for (QueryAnalyzer.QueryExtraction extraction : result.extractions) {
            if (extraction.term != null) {
                BytesRefBuilder builder = new BytesRefBuilder();
                builder.append(new BytesRef(extraction.field()));
                builder.append((byte)0);
                builder.append(extraction.bytes());
                doc.add(new Field(this.queryTermsField.name(), builder.toBytesRef(), (IndexableFieldType)this.queryTermsField.fieldType()));
                continue;
            }
            if (extraction.range == null) continue;
            byte[] min = extraction.range.lowerPoint;
            byte[] max = extraction.range.upperPoint;
            doc.add(new BinaryRange(this.rangeFieldMapper.name(), PercolatorFieldMapper.encodeRange(extraction.range.fieldName, min, max)));
        }
        Version indexVersionCreated = context.mapperService().getIndexSettings().getIndexVersionCreated();
        if (result.matchAllDocs) {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_FAILED, (IndexableFieldType)this.extractionResultField.fieldType()));
            if (result.verified) {
                doc.add(new Field(this.extractionResultField.name(), EXTRACTION_COMPLETE, (IndexableFieldType)this.extractionResultField.fieldType()));
            }
        } else if (result.verified) {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_COMPLETE, (IndexableFieldType)this.extractionResultField.fieldType()));
        } else {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_PARTIAL, (IndexableFieldType)this.extractionResultField.fieldType()));
        }
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(1);
        this.createFieldNamesField(context, fields);
        for (IndexableField field : fields) {
            context.doc().add(field);
        }
        if (indexVersionCreated.onOrAfter(Version.V_6_1_0)) {
            doc.add(new NumericDocValuesField(this.minimumShouldMatchFieldMapper.name(), result.minimumShouldMatch));
        }
    }

    static Query parseQuery(QueryShardContext context, boolean mapUnmappedFieldsAsString, XContentParser parser) throws IOException {
        return PercolatorFieldMapper.toQuery(context, mapUnmappedFieldsAsString, PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation()));
    }

    static Query toQuery(QueryShardContext context, boolean mapUnmappedFieldsAsString, QueryBuilder queryBuilder) throws IOException {
        context.setAllowUnmappedFields(false);
        context.setMapUnmappedFieldAsString(mapUnmappedFieldsAsString);
        return queryBuilder.toQuery(context);
    }

    private static QueryBuilder parseQueryBuilder(XContentParser parser, XContentLocation location) {
        try {
            return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        }
        catch (IOException e) {
            throw new ParsingException(location, "Failed to parse", e, new Object[0]);
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        return Arrays.asList(this.queryTermsField, this.extractionResultField, this.queryBuilderField, this.minimumShouldMatchFieldMapper, this.rangeFieldMapper).iterator();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("should not be invoked");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    boolean isMapUnmappedFieldAsText() {
        return this.mapUnmappedFieldAsText;
    }

    static void verifyQuery(QueryBuilder queryBuilder) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (queryBuilder.getName().equals("has_child")) {
                                throw new IllegalArgumentException("the [has_child] query is unsupported inside a percolator query");
                            }
                            if (queryBuilder.getName().equals("has_parent")) {
                                throw new IllegalArgumentException("the [has_parent] query is unsupported inside a percolator query");
                            }
                            if (!(queryBuilder instanceof BoolQueryBuilder)) break block4;
                            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                            ArrayList<QueryBuilder> clauses = new ArrayList<QueryBuilder>();
                            clauses.addAll(boolQueryBuilder.filter());
                            clauses.addAll(boolQueryBuilder.must());
                            clauses.addAll(boolQueryBuilder.mustNot());
                            clauses.addAll(boolQueryBuilder.should());
                            for (QueryBuilder clause : clauses) {
                                PercolatorFieldMapper.verifyQuery(clause);
                            }
                            break block5;
                        }
                        if (!(queryBuilder instanceof ConstantScoreQueryBuilder)) break block6;
                        PercolatorFieldMapper.verifyQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
                        break block5;
                    }
                    if (!(queryBuilder instanceof FunctionScoreQueryBuilder)) break block7;
                    PercolatorFieldMapper.verifyQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
                    break block5;
                }
                if (!(queryBuilder instanceof BoostingQueryBuilder)) break block8;
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
                break block5;
            }
            if (!(queryBuilder instanceof DisMaxQueryBuilder)) break block5;
            DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
            for (QueryBuilder innerQueryBuilder : disMaxQueryBuilder.innerQueries()) {
                PercolatorFieldMapper.verifyQuery(innerQueryBuilder);
            }
        }
    }

    static byte[] encodeRange(String rangeFieldName, byte[] minEncoded, byte[] maxEncoded) {
        assert (minEncoded.length == maxEncoded.length);
        byte[] bytes = new byte[32];
        BytesRef fieldAsBytesRef = new BytesRef(rangeFieldName);
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128(fieldAsBytesRef.bytes, fieldAsBytesRef.offset, fieldAsBytesRef.length, 0L, hash);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putLong(hash.h1).putLong(hash.h2).putLong(hash.h1).putLong(hash.h2);
        assert (bb.position() == bb.limit());
        int offset = 16 - minEncoded.length;
        System.arraycopy(minEncoded, 0, bytes, offset, minEncoded.length);
        System.arraycopy(maxEncoded, 0, bytes, 16 + offset, maxEncoded.length);
        return bytes;
    }

    static class FieldType
    extends MappedFieldType {
        MappedFieldType queryTermsField;
        MappedFieldType extractionResultField;
        MappedFieldType queryBuilderField;
        MappedFieldType minimumShouldMatchField;
        RangeFieldMapper.RangeFieldType rangeField;

        FieldType() {
            this.setIndexOptions(IndexOptions.NONE);
            this.setDocValuesType(DocValuesType.NONE);
            this.setStored(false);
        }

        FieldType(FieldType ref) {
            super(ref);
            this.queryTermsField = ref.queryTermsField;
            this.extractionResultField = ref.extractionResultField;
            this.queryBuilderField = ref.queryBuilderField;
            this.rangeField = ref.rangeField;
            this.minimumShouldMatchField = ref.minimumShouldMatchField;
        }

        @Override
        public MappedFieldType clone() {
            return new FieldType(this);
        }

        @Override
        public String typeName() {
            return PercolatorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Percolator fields are not searchable directly, use a percolate query instead", new Object[0]);
        }

        Query percolateQuery(String name, PercolateQuery.QueryStore queryStore, List<BytesReference> documents, IndexSearcher searcher, Version indexVersion) throws IOException {
            IndexReader indexReader = searcher.getIndexReader();
            Tuple<BooleanQuery, Boolean> t = this.createCandidateQuery(indexReader, indexVersion);
            Query candidateQuery = t.v1();
            boolean canUseMinimumShouldMatchField = t.v2();
            Query verifiedMatchesQuery = canUseMinimumShouldMatchField && indexReader.maxDoc() == 1 ? new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_COMPLETE)) : new MatchNoDocsQuery("multiple or nested docs or CoveringQuery could not be used");
            return new PercolateQuery(name, queryStore, documents, candidateQuery, searcher, verifiedMatchesQuery);
        }

        Tuple<BooleanQuery, Boolean> createCandidateQuery(IndexReader indexReader, Version indexVersion) throws IOException {
            Tuple<List<BytesRef>, Map<String, List<byte[]>>> t = this.extractTermsAndRanges(indexReader);
            List<BytesRef> extractedTerms = t.v1();
            Map<String, List<byte[]>> encodedPointValuesByField = t.v2();
            boolean canUseMinimumShouldMatchField = 1 + extractedTerms.size() + encodedPointValuesByField.size() <= BooleanQuery.getMaxClauseCount();
            ArrayList<Query> subQueries = new ArrayList<Query>();
            for (Map.Entry<String, List<byte[]>> entry : encodedPointValuesByField.entrySet()) {
                String rangeFieldName = entry.getKey();
                List<byte[]> encodedPointValues = entry.getValue();
                byte[] min = encodedPointValues.get(0);
                byte[] max = encodedPointValues.get(1);
                Query query = BinaryRange.newIntersectsQuery(this.rangeField.name(), PercolatorFieldMapper.encodeRange(rangeFieldName, min, max));
                subQueries.add(query);
            }
            BooleanQuery.Builder candidateQuery = new BooleanQuery.Builder();
            if (canUseMinimumShouldMatchField && indexVersion.onOrAfter(Version.V_6_1_0)) {
                LongValuesSource valuesSource = LongValuesSource.fromIntField(this.minimumShouldMatchField.name());
                for (BytesRef extractedTerm : extractedTerms) {
                    subQueries.add(new TermQuery(new Term(this.queryTermsField.name(), extractedTerm)));
                }
                candidateQuery.add(new CoveringQuery(subQueries, valuesSource), BooleanClause.Occur.SHOULD);
            } else {
                candidateQuery.add(new TermInSetQuery(this.queryTermsField.name(), extractedTerms), BooleanClause.Occur.SHOULD);
                for (Query subQuery : subQueries) {
                    candidateQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                }
            }
            candidateQuery.add(new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_FAILED)), BooleanClause.Occur.SHOULD);
            return new Tuple<BooleanQuery, Boolean>(candidateQuery.build(), canUseMinimumShouldMatchField);
        }

        Tuple<List<BytesRef>, Map<String, List<byte[]>>> extractTermsAndRanges(IndexReader indexReader) throws IOException {
            ArrayList<BytesRef> extractedTerms = new ArrayList<BytesRef>();
            HashMap encodedPointValuesByField = new HashMap();
            LeafReader reader = indexReader.leaves().get(0).reader();
            for (FieldInfo info : reader.getFieldInfos()) {
                Terms terms = reader.terms(info.name);
                if (terms != null) {
                    BytesRef fieldBr = new BytesRef(info.name);
                    TermsEnum tenum = terms.iterator();
                    BytesRef term = tenum.next();
                    while (term != null) {
                        BytesRefBuilder builder = new BytesRefBuilder();
                        builder.append(fieldBr);
                        builder.append((byte)0);
                        builder.append(term);
                        extractedTerms.add(builder.toBytesRef());
                        term = tenum.next();
                    }
                }
                if (info.getPointDimensionCount() != 1) continue;
                PointValues values = reader.getPointValues(info.name);
                ArrayList<byte[]> encodedPointValues = new ArrayList<byte[]>();
                encodedPointValues.add((byte[])values.getMinPackedValue().clone());
                encodedPointValues.add((byte[])values.getMaxPackedValue().clone());
                encodedPointValuesByField.put(info.name, encodedPointValues);
            }
            return new Tuple<List<BytesRef>, Map<String, List<byte[]>>>(extractedTerms, encodedPointValuesByField);
        }
    }

    static class TypeParser
    implements Mapper.TypeParser {
        TypeParser() {
        }

        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(name, parserContext.queryShardContextSupplier());
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder, PercolatorFieldMapper> {
        private final Supplier<QueryShardContext> queryShardContext;

        Builder(String fieldName, Supplier<QueryShardContext> queryShardContext) {
            super(fieldName, FIELD_TYPE, FIELD_TYPE);
            this.queryShardContext = queryShardContext;
        }

        @Override
        public PercolatorFieldMapper build(Mapper.BuilderContext context) {
            context.path().add(this.name());
            FieldType fieldType = (FieldType)this.fieldType;
            KeywordFieldMapper extractedTermsField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTED_TERMS_FIELD_NAME, context);
            fieldType.queryTermsField = extractedTermsField.fieldType();
            KeywordFieldMapper extractionResultField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTION_RESULT_FIELD_NAME, context);
            fieldType.extractionResultField = extractionResultField.fieldType();
            BinaryFieldMapper queryBuilderField = Builder.createQueryBuilderFieldBuilder(context);
            fieldType.queryBuilderField = queryBuilderField.fieldType();
            RangeFieldMapper rangeFieldMapper = Builder.createExtractedRangeFieldBuilder(PercolatorFieldMapper.RANGE_FIELD_NAME, RangeFieldMapper.RangeType.IP, context);
            fieldType.rangeField = rangeFieldMapper.fieldType();
            NumberFieldMapper minimumShouldMatchFieldMapper = Builder.createMinimumShouldMatchField(context);
            fieldType.minimumShouldMatchField = minimumShouldMatchFieldMapper.fieldType();
            context.path().remove();
            this.setupFieldType(context);
            return new PercolatorFieldMapper(this.name(), fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo, this.queryShardContext, extractedTermsField, extractionResultField, queryBuilderField, rangeFieldMapper, minimumShouldMatchFieldMapper);
        }

        static KeywordFieldMapper createExtractQueryFieldBuilder(String name, Mapper.BuilderContext context) {
            KeywordFieldMapper.Builder queryMetaDataFieldBuilder = new KeywordFieldMapper.Builder(name);
            queryMetaDataFieldBuilder.docValues(false);
            queryMetaDataFieldBuilder.store(false);
            queryMetaDataFieldBuilder.indexOptions(IndexOptions.DOCS);
            return queryMetaDataFieldBuilder.build(context);
        }

        static BinaryFieldMapper createQueryBuilderFieldBuilder(Mapper.BuilderContext context) {
            BinaryFieldMapper.Builder builder = new BinaryFieldMapper.Builder(PercolatorFieldMapper.QUERY_BUILDER_FIELD_NAME);
            builder.docValues(true);
            builder.indexOptions(IndexOptions.NONE);
            builder.store(false);
            builder.fieldType().setDocValuesType(DocValuesType.BINARY);
            return builder.build(context);
        }

        static RangeFieldMapper createExtractedRangeFieldBuilder(String name, RangeFieldMapper.RangeType rangeType, Mapper.BuilderContext context) {
            RangeFieldMapper.Builder builder = new RangeFieldMapper.Builder(name, rangeType, context.indexCreatedVersion());
            builder.docValues(false);
            return builder.build(context);
        }

        static NumberFieldMapper createMinimumShouldMatchField(Mapper.BuilderContext context) {
            NumberFieldMapper.Builder builder = new NumberFieldMapper.Builder(PercolatorFieldMapper.MINIMUM_SHOULD_MATCH_FIELD_NAME, NumberFieldMapper.NumberType.INTEGER);
            builder.index(false);
            builder.store(false);
            builder.docValues(true);
            builder.fieldType().setDocValuesType(DocValuesType.NUMERIC);
            return builder.build(context);
        }
    }
}

