/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import org.elasticsearch.index.reindex.RethrottleAction;
import org.elasticsearch.index.reindex.RethrottleRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRethrottleAction
extends TransportTasksAction<BulkByScrollTask, RethrottleRequest, ListTasksResponse, TaskInfo> {
    private final Client client;

    @Inject
    public TransportRethrottleAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:admin/reindex/rethrottle", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, RethrottleRequest::new, ListTasksResponse::new, "management");
        this.client = client;
    }

    @Override
    protected void taskOperation(RethrottleRequest request, BulkByScrollTask task, ActionListener<TaskInfo> listener) {
        TransportRethrottleAction.rethrottle(this.logger, this.clusterService.localNode().getId(), this.client, task, request.getRequestsPerSecond(), listener);
    }

    static void rethrottle(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        if (task.isWorker()) {
            TransportRethrottleAction.rethrottleChildTask(logger, localNodeId, task, newRequestsPerSecond, listener);
            return;
        }
        if (task.isLeader()) {
            TransportRethrottleAction.rethrottleParentTask(logger, localNodeId, client, task, newRequestsPerSecond, listener);
            return;
        }
        throw new IllegalArgumentException("task [" + task.getId() + "] has not yet been initialized to the point where it knows how to rethrottle itself");
    }

    private static void rethrottleParentTask(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        LeaderBulkByScrollTaskState leaderState = task.getLeaderState();
        int runningSubtasks = leaderState.runningSliceSubTasks();
        if (runningSubtasks > 0) {
            RethrottleRequest subRequest = new RethrottleRequest();
            subRequest.setRequestsPerSecond(newRequestsPerSecond / (float)runningSubtasks);
            subRequest.setParentTaskId(new TaskId(localNodeId, task.getId()));
            logger.debug("rethrottling children of task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(subRequest.getRequestsPerSecond()));
            client.execute(RethrottleAction.INSTANCE, subRequest, ActionListener.wrap(r -> {
                r.rethrowFailures("Rethrottle");
                listener.onResponse(task.taskInfoGivenSubtaskInfo(localNodeId, r.getTasks()));
            }, listener::onFailure));
        } else {
            logger.debug("children of task [{}] are already finished, nothing to rethrottle", (Object)task.getId());
            listener.onResponse(task.taskInfo(localNodeId, true));
        }
    }

    private static void rethrottleChildTask(Logger logger, String localNodeId, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        logger.debug("rethrottling local task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
        task.getWorkerState().rethrottle(newRequestsPerSecond);
        listener.onResponse(task.taskInfo(localNodeId, true));
    }

    @Override
    protected TaskInfo readTaskResponse(StreamInput in) throws IOException {
        return new TaskInfo(in);
    }

    @Override
    protected ListTasksResponse newResponse(RethrottleRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }
}

