/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ClientScrollableHitSource;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>> {
    protected final Logger logger;
    protected final BulkByScrollTask task;
    protected final WorkerBulkByScrollTaskState worker;
    protected final ThreadPool threadPool;
    protected final ScriptService scriptService;
    protected final ClusterState clusterState;
    protected final Request mainRequest;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ParentTaskAssigningClient client;
    private final ActionListener<BulkByScrollResponse> listener;
    private final Retry bulkRetry;
    private final ScrollableHitSource scrollSource;
    private final Settings settings;
    private final BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> scriptApplier;

    public AbstractAsyncBulkByScrollAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        this(task, logger, client, threadPool, mainRequest, scriptService, clusterState, listener, client.settings());
    }

    public AbstractAsyncBulkByScrollAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener, Settings settings) {
        this.task = task;
        if (!task.isWorker()) {
            throw new IllegalArgumentException("Given task [" + task.getId() + "] must have a child worker");
        }
        this.worker = task.getWorkerState();
        this.logger = logger;
        this.client = client;
        this.settings = settings;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.clusterState = clusterState;
        this.mainRequest = mainRequest;
        this.listener = listener;
        BackoffPolicy backoffPolicy = this.buildBackoffPolicy();
        this.bulkRetry = new Retry(BackoffPolicy.wrap(backoffPolicy, this.worker::countBulkRetry), threadPool);
        this.scrollSource = this.buildScrollableResultSource(backoffPolicy);
        this.scriptApplier = Objects.requireNonNull(this.buildScriptApplier(), "script applier must not be null");
        List<SortBuilder<?>> sorts = ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().sorts();
        if (sorts == null || sorts.isEmpty()) {
            ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().sort(SortBuilders.fieldSort("_doc"));
        }
        ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().version(this.needsSourceDocumentVersions());
    }

    public BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> buildScriptApplier() {
        return (request, searchHit) -> request;
    }

    protected abstract boolean needsSourceDocumentVersions();

    protected abstract RequestWrapper<?> buildRequest(ScrollableHitSource.Hit var1);

    protected RequestWrapper<?> copyMetadata(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        request.setParent(doc.getParent());
        this.copyRouting(request, doc.getRouting());
        return request;
    }

    protected void copyRouting(RequestWrapper<?> request, String routing) {
        request.setRouting(routing);
    }

    protected boolean accept(ScrollableHitSource.Hit doc) {
        if (doc.getSource() == null) {
            throw new IllegalArgumentException("[" + doc.getIndex() + "][" + doc.getType() + "][" + doc.getId() + "] didn't store _source");
        }
        return true;
    }

    private BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> docs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (ScrollableHitSource.Hit hit : docs) {
            RequestWrapper<?> request;
            if (!this.accept(hit) || (request = this.scriptApplier.apply(this.copyMetadata(this.buildRequest(hit), hit), hit)) == null) continue;
            bulkRequest.add((DocWriteRequest)request.self());
        }
        return bulkRequest;
    }

    protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
        return new ClientScrollableHitSource(this.logger, backoffPolicy, this.threadPool, this.worker::countSearchRetry, this::finishHim, this.client, ((AbstractBulkByScrollRequest)this.mainRequest).getSearchRequest());
    }

    protected BulkByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        return new BulkByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
    }

    public void start() {
        this.logger.debug("[{}]: starting", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            this.scrollSource.start(response -> this.onScrollResponse(TimeValue.timeValueNanos(System.nanoTime()), 0, (ScrollableHitSource.Response)response));
        }
        catch (Exception e) {
            this.finishHim(e);
        }
    }

    void onScrollResponse(TimeValue lastBatchStartTime, int lastBatchSize, final ScrollableHitSource.Response response) {
        this.logger.debug("[{}]: got scroll response with [{}] hits", (Object)this.task.getId(), (Object)response.getHits().size());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (response.getFailures().size() > 0 || response.isTimedOut()) {
            this.refreshAndFinish(Collections.emptyList(), response.getFailures(), response.isTimedOut());
            return;
        }
        long total = response.getTotalHits();
        if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() > 0) {
            total = Math.min(total, (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize());
        }
        this.worker.setTotal(total);
        AbstractRunnable prepareBulkRequestRunnable = new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                AbstractAsyncBulkByScrollAction.this.prepareBulkRequest(TimeValue.timeValueNanos(System.nanoTime()), response);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        };
        prepareBulkRequestRunnable = (AbstractRunnable)this.threadPool.getThreadContext().preserveContext(prepareBulkRequestRunnable);
        this.worker.delayPrepareBulkRequest(this.threadPool, lastBatchStartTime, lastBatchSize, prepareBulkRequestRunnable);
    }

    void prepareBulkRequest(TimeValue thisBatchStartTime, ScrollableHitSource.Response response) {
        BulkRequest request;
        long remaining;
        this.logger.debug("[{}]: preparing bulk request", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (response.getHits().isEmpty()) {
            this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
            return;
        }
        this.worker.countBatch();
        List<? extends ScrollableHitSource.Hit> hits = response.getHits();
        if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() != -1 && (remaining = Math.max(0L, (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize() - this.worker.getSuccessfullyProcessed())) < (long)hits.size()) {
            hits = hits.subList(0, (int)remaining);
        }
        if ((request = this.buildBulk(hits)).requests().isEmpty()) {
            this.startNextScroll(thisBatchStartTime, TimeValue.timeValueNanos(System.nanoTime()), 0);
            return;
        }
        request.timeout(((AbstractBulkByScrollRequest)this.mainRequest).getTimeout());
        request.waitForActiveShards(((AbstractBulkByScrollRequest)this.mainRequest).getWaitForActiveShards());
        this.sendBulkRequest(thisBatchStartTime, request);
    }

    void sendBulkRequest(final TimeValue thisBatchStartTime, BulkRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]: sending [{}] entry, [{}] bulk request", (Object)this.task.getId(), (Object)request.requests().size(), (Object)new ByteSizeValue(request.estimatedSizeInBytes()));
        }
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        this.bulkRetry.withBackoff(this.client::bulk, request, new ActionListener<BulkResponse>(){

            @Override
            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(thisBatchStartTime, response);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        }, this.settings);
    }

    void onBulkResponse(TimeValue thisBatchStartTime, BulkResponse response) {
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case CREATE: 
                    case INDEX: {
                        if (((DocWriteResponse)item.getResponse()).getResult() == DocWriteResponse.Result.CREATED) {
                            this.worker.countCreated();
                            break;
                        }
                        this.worker.countUpdated();
                        break;
                    }
                    case UPDATE: {
                        this.worker.countUpdated();
                        break;
                    }
                    case DELETE: {
                        this.worker.countDeleted();
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            if (this.task.isCancelled()) {
                this.logger.debug("[{}]: Finishing early because the task was cancelled", (Object)this.task.getId());
                this.finishHim(null);
                return;
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.refreshAndFinish(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() != -1 && this.worker.getSuccessfullyProcessed() >= (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize()) {
                this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            this.startNextScroll(thisBatchStartTime, TimeValue.timeValueNanos(System.nanoTime()), response.getItems().length);
        }
        catch (Exception t) {
            this.finishHim(t);
        }
    }

    void startNextScroll(TimeValue lastBatchStartTime, TimeValue now, int lastBatchSize) {
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        TimeValue extraKeepAlive = this.worker.throttleWaitTime(lastBatchStartTime, now, lastBatchSize);
        this.scrollSource.startNextScroll(extraKeepAlive, response -> this.onScrollResponse(lastBatchStartTime, lastBatchSize, (ScrollableHitSource.Response)response));
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.worker.countVersionConflict();
            if (!((AbstractBulkByScrollRequest)this.mainRequest).isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void refreshAndFinish(final List<BulkItemResponse.Failure> indexingFailures, final List<ScrollableHitSource.SearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !((AbstractBulkByScrollRequest)this.mainRequest).isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(new String[0]);
        refresh.indices(this.destinationIndices.toArray(new String[this.destinationIndices.size()]));
        this.logger.debug("[{}]: refreshing", (Object)this.task.getId());
        this.client.admin().indices().refresh(refresh, new ActionListener<RefreshResponse>(){

            @Override
            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    protected void finishHim(Exception failure) {
        this.logger.debug(() -> new ParameterizedMessage("[{}]: finishing with a catastrophic failure", (Object)this.task.getId()), (Throwable)failure);
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.logger.debug("[{}]: finishing without any catastrophic failures", (Object)this.task.getId());
        this.scrollSource.close(() -> {
            if (failure == null) {
                BulkByScrollResponse response = this.buildResponse(TimeValue.timeValueNanos(System.nanoTime() - this.startTime.get()), indexingFailures, searchFailures, timedOut);
                this.listener.onResponse(response);
            } else {
                this.listener.onFailure(failure);
            }
        });
    }

    BackoffPolicy buildBackoffPolicy() {
        return BackoffPolicy.exponentialBackoff(((AbstractBulkByScrollRequest)this.mainRequest).getRetryBackoffInitialTime(), ((AbstractBulkByScrollRequest)this.mainRequest).getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    void setScroll(String scroll) {
        this.scrollSource.setScroll(scroll);
    }

    public static RequestWrapper<IndexRequest> wrap(IndexRequest request) {
        return new IndexRequestWrapper(request);
    }

    public static RequestWrapper<DeleteRequest> wrap(DeleteRequest request) {
        return new DeleteRequestWrapper(request);
    }

    public static enum OpType {
        NOOP("noop"),
        INDEX("index"),
        DELETE("delete");

        private final String id;

        private OpType(String id) {
            this.id = id;
        }

        public static OpType fromString(String opType) {
            String lowerOpType;
            switch (lowerOpType = opType.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Operation type [" + lowerOpType + "] not allowed, only " + Arrays.toString((Object[])OpType.values()) + " are allowed");
        }

        public String toString() {
            return this.id.toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class ScriptApplier
    implements BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> {
        private final WorkerBulkByScrollTaskState taskWorker;
        private final ScriptService scriptService;
        private final Script script;
        private final Map<String, Object> params;
        private ExecutableScript executable;
        private Map<String, Object> context;

        public ScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
            this.taskWorker = taskWorker;
            this.scriptService = scriptService;
            this.script = script;
            this.params = params;
        }

        @Override
        public RequestWrapper<?> apply(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            OpType newOpType;
            if (this.script == null) {
                return request;
            }
            if (this.executable == null) {
                ExecutableScript.Factory factory = this.scriptService.compile(this.script, ExecutableScript.UPDATE_CONTEXT);
                this.executable = factory.newInstance(this.params);
            }
            if (this.context == null) {
                this.context = new HashMap<String, Object>();
            } else {
                this.context.clear();
            }
            this.context.put("_index", doc.getIndex());
            this.context.put("_type", doc.getType());
            this.context.put("_id", doc.getId());
            Long oldVersion = doc.getVersion();
            this.context.put("_version", oldVersion);
            String oldParent = doc.getParent();
            this.context.put("_parent", oldParent);
            String oldRouting = doc.getRouting();
            this.context.put("_routing", oldRouting);
            this.context.put("_source", request.getSource());
            OpType oldOpType = OpType.INDEX;
            this.context.put("op", oldOpType.toString());
            this.executable.setNextVar("ctx", this.context);
            this.executable.run();
            String newOp = (String)this.context.remove("op");
            if (newOp == null) {
                throw new IllegalArgumentException("Script cleared operation type");
            }
            request.setSource((Map)this.context.remove("_source"));
            Object newValue = this.context.remove("_index");
            if (!doc.getIndex().equals(newValue)) {
                this.scriptChangedIndex(request, newValue);
            }
            newValue = this.context.remove("_type");
            if (!doc.getType().equals(newValue)) {
                this.scriptChangedType(request, newValue);
            }
            newValue = this.context.remove("_id");
            if (!doc.getId().equals(newValue)) {
                this.scriptChangedId(request, newValue);
            }
            if (!Objects.equals(oldVersion, newValue = this.context.remove("_version"))) {
                this.scriptChangedVersion(request, newValue);
            }
            if (!Objects.equals(oldParent, newValue = this.context.remove("_parent"))) {
                this.scriptChangedParent(request, newValue);
            }
            if (!Objects.equals(oldRouting, newValue = this.context.remove("_routing"))) {
                this.scriptChangedRouting(request, newValue);
            }
            if ((newOpType = OpType.fromString(newOp)) != oldOpType) {
                return this.scriptChangedOpType(request, oldOpType, newOpType);
            }
            if (!this.context.isEmpty()) {
                throw new IllegalArgumentException("Invalid fields added to context [" + String.join((CharSequence)",", this.context.keySet()) + ']');
            }
            return request;
        }

        protected RequestWrapper<?> scriptChangedOpType(RequestWrapper<?> request, OpType oldOpType, OpType newOpType) {
            switch (newOpType) {
                case NOOP: {
                    this.taskWorker.countNoop();
                    return null;
                }
                case DELETE: {
                    RequestWrapper<DeleteRequest> delete = AbstractAsyncBulkByScrollAction.wrap(new DeleteRequest(request.getIndex(), request.getType(), request.getId()));
                    delete.setVersion(request.getVersion());
                    delete.setVersionType(VersionType.INTERNAL);
                    delete.setParent(request.getParent());
                    delete.setRouting(request.getRouting());
                    return delete;
                }
            }
            throw new IllegalArgumentException("Unsupported operation type change from [" + (Object)((Object)oldOpType) + "] to [" + (Object)((Object)newOpType) + "]");
        }

        protected abstract void scriptChangedIndex(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedType(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedId(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedVersion(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedRouting(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedParent(RequestWrapper<?> var1, Object var2);
    }

    public static class DeleteRequestWrapper
    implements RequestWrapper<DeleteRequest> {
        private final DeleteRequest request;

        DeleteRequestWrapper(DeleteRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped DeleteRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            throw new UnsupportedOperationException("unable to get source from action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setSource(Map<String, Object> source) {
            throw new UnsupportedOperationException("unable to set [source] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public DeleteRequest self() {
            return this.request;
        }
    }

    public static class IndexRequestWrapper
    implements RequestWrapper<IndexRequest> {
        private final IndexRequest request;

        IndexRequestWrapper(IndexRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped IndexRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            return this.request.sourceAsMap();
        }

        @Override
        public void setSource(Map<String, Object> source) {
            this.request.source(source);
        }

        @Override
        public IndexRequest self() {
            return this.request;
        }
    }

    public static interface RequestWrapper<Self extends DocWriteRequest<Self>> {
        public void setIndex(String var1);

        public String getIndex();

        public void setType(String var1);

        public String getType();

        public void setId(String var1);

        public String getId();

        public void setVersion(long var1);

        public long getVersion();

        public void setVersionType(VersionType var1);

        public void setParent(String var1);

        public String getParent();

        public void setRouting(String var1);

        public String getRouting();

        public void setSource(Map<String, Object> var1);

        public Map<String, Object> getSource();

        public Self self();
    }
}

