/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;

public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;

    public ClusterChangedEvent(String source, ClusterState state, ClusterState previousState) {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(previousState, "previousState must not be null");
        this.source = source;
        this.state = state;
        this.previousState = previousState;
        this.nodesDelta = state.nodes().delta(previousState.nodes());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.routingTable() != this.previousState.routingTable();
    }

    public boolean indexRoutingTableChanged(String index) {
        Objects.requireNonNull(index, "index must not be null");
        if (!this.state.routingTable().hasIndex(index) && !this.previousState.routingTable().hasIndex(index)) {
            return false;
        }
        if (this.state.routingTable().hasIndex(index) && this.previousState.routingTable().hasIndex(index)) {
            return this.state.routingTable().index(index) != this.previousState.routingTable().index(index);
        }
        return true;
    }

    public List<String> indicesCreated() {
        if (!this.metaDataChanged()) {
            return Collections.emptyList();
        }
        ArrayList<String> created = null;
        for (ObjectCursor cursor : this.state.metaData().indices().keys()) {
            String index = (String)cursor.value;
            if (this.previousState.metaData().hasIndex(index)) continue;
            if (created == null) {
                created = new ArrayList<String>();
            }
            created.add(index);
        }
        return created == null ? Collections.emptyList() : created;
    }

    public List<Index> indicesDeleted() {
        if (this.previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return this.indicesDeletedFromTombstones();
        }
        return this.indicesDeletedFromClusterState();
    }

    public boolean metaDataChanged() {
        return this.state.metaData() != this.previousState.metaData();
    }

    public Set<String> changedCustomMetaDataSet() {
        ImmutableOpenMap<String, MetaData.Custom> previousCustoms;
        HashSet<String> result = new HashSet<String>();
        ImmutableOpenMap<String, MetaData.Custom> currentCustoms = this.state.metaData().customs();
        if (!currentCustoms.equals(previousCustoms = this.previousState.metaData().customs())) {
            for (ObjectObjectCursor<String, MetaData.Custom> objectObjectCursor : currentCustoms) {
                if (previousCustoms.containsKey((String)objectObjectCursor.key) && ((MetaData.Custom)objectObjectCursor.value).equals(previousCustoms.get((String)objectObjectCursor.key))) continue;
                result.add((String)objectObjectCursor.key);
            }
            for (ObjectObjectCursor<String, MetaData.Custom> objectObjectCursor : previousCustoms) {
                if (currentCustoms.containsKey((String)objectObjectCursor.key)) continue;
                result.add((String)objectObjectCursor.key);
            }
        }
        return result;
    }

    public static boolean indexMetaDataChanged(IndexMetaData metaData1, IndexMetaData metaData2) {
        assert (metaData1 != null && metaData2 != null);
        return metaData1 != metaData2;
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeMaster() {
        return this.state.nodes().isLocalNodeElectedMaster();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }

    public boolean isNewCluster() {
        String currClusterUUID;
        String prevClusterUUID = this.previousState.metaData().clusterUUID();
        return !prevClusterUUID.equals(currClusterUUID = this.state.metaData().clusterUUID());
    }

    private List<Index> indicesDeletedFromClusterState() {
        if (!this.metaDataChanged() || this.isNewCluster()) {
            return Collections.emptyList();
        }
        ArrayList<Index> deleted = null;
        for (ObjectCursor<IndexMetaData> objectCursor : this.previousState.metaData().indices().values()) {
            IndexMetaData index = (IndexMetaData)objectCursor.value;
            IndexMetaData current = this.state.metaData().index(index.getIndex());
            if (current != null) continue;
            if (deleted == null) {
                deleted = new ArrayList<Index>();
            }
            deleted.add(index.getIndex());
        }
        return deleted == null ? Collections.emptyList() : deleted;
    }

    private List<Index> indicesDeletedFromTombstones() {
        List<IndexGraveyard.Tombstone> tombstones = this.state.metaData().indexGraveyard().getTombstones();
        return tombstones.stream().map(IndexGraveyard.Tombstone::getIndex).collect(Collectors.toList());
    }
}

