/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.schema.handler;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableNameEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.schema.handler.TableSchemaChangeEventHandler;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class AlterTableSchemaEventHandler
implements TableSchemaChangeEventHandler {
    private TableSchema schema;

    @Override
    public TableSchema get() {
        return this.schema;
    }

    @Override
    public TableSchemaChangeEventHandler reset(TableSchema schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public TableSchema apply(SchemaChangeEvent event) {
        AlterTableEvent alterTableEvent = (AlterTableEvent)event;
        return this.apply(this.schema, alterTableEvent);
    }

    private TableSchema apply(TableSchema schema, AlterTableEvent alterTableEvent) {
        if (alterTableEvent instanceof AlterTableNameEvent) {
            return schema;
        }
        if (alterTableEvent instanceof AlterTableDropColumnEvent) {
            return this.applyDropColumn(schema, (AlterTableDropColumnEvent)alterTableEvent);
        }
        if (alterTableEvent instanceof AlterTableModifyColumnEvent) {
            return this.applyModifyColumn(schema, (AlterTableModifyColumnEvent)alterTableEvent);
        }
        if (alterTableEvent instanceof AlterTableChangeColumnEvent) {
            return this.applyChangeColumn(schema, (AlterTableChangeColumnEvent)alterTableEvent);
        }
        if (alterTableEvent instanceof AlterTableAddColumnEvent) {
            return this.applyAddColumn(schema, (AlterTableAddColumnEvent)alterTableEvent);
        }
        if (alterTableEvent instanceof AlterTableColumnsEvent) {
            TableSchema newSchema = schema;
            for (AlterTableColumnEvent columnEvent : ((AlterTableColumnsEvent)alterTableEvent).getEvents()) {
                newSchema = this.apply(newSchema, columnEvent);
            }
            return newSchema;
        }
        throw new UnsupportedOperationException("Unsupported alter table event: " + alterTableEvent);
    }

    private TableSchema applyAddColumn(TableSchema schema, AlterTableAddColumnEvent addColumnEvent) {
        Column column;
        LinkedList<String> originFields = new LinkedList<String>(Arrays.asList(schema.getFieldNames()));
        if (originFields.contains((column = addColumnEvent.getColumn()).getName())) {
            return this.applyModifyColumn(schema, new AlterTableModifyColumnEvent(addColumnEvent.tableIdentifier(), addColumnEvent.getColumn(), addColumnEvent.isFirst(), addColumnEvent.getAfterColumn()));
        }
        LinkedList<Column> newColumns = new LinkedList<Column>(schema.getColumns());
        if (addColumnEvent.isFirst()) {
            newColumns.addFirst(column);
        } else if (addColumnEvent.getAfterColumn() != null) {
            int index = originFields.indexOf(addColumnEvent.getAfterColumn());
            newColumns.add(index + 1, column);
        } else {
            newColumns.addLast(column);
        }
        return TableSchema.builder().columns(newColumns).primaryKey(schema.getPrimaryKey()).constraintKey(schema.getConstraintKeys()).build();
    }

    private TableSchema applyDropColumn(TableSchema schema, AlterTableDropColumnEvent dropColumnEvent) {
        List<Column> newColumns = schema.getColumns().stream().filter(c -> !c.getName().equals(dropColumnEvent.getColumn())).collect(Collectors.toList());
        return TableSchema.builder().columns(newColumns).primaryKey(schema.getPrimaryKey()).constraintKey(schema.getConstraintKeys()).build();
    }

    private TableSchema applyModifyColumn(TableSchema schema, AlterTableModifyColumnEvent modifyColumnEvent) {
        List<String> fieldNames = Arrays.asList(schema.getFieldNames());
        if (!fieldNames.contains(modifyColumnEvent.getColumn().getName())) {
            return schema;
        }
        String modifyColumnName = modifyColumnEvent.getColumn().getName();
        int modifyColumnIndex = fieldNames.indexOf(modifyColumnName);
        return this.applyModifyColumn(schema, modifyColumnIndex, modifyColumnEvent.getColumn(), modifyColumnEvent.isFirst(), modifyColumnEvent.getAfterColumn());
    }

    private TableSchema applyChangeColumn(TableSchema schema, AlterTableChangeColumnEvent changeColumnEvent) {
        String oldColumn = changeColumnEvent.getOldColumn();
        int oldColumnIndex = schema.indexOf(oldColumn);
        Column column = changeColumnEvent.getColumn();
        if (column.getDataType() == null) {
            SeaTunnelDataType<?> fieldType = schema.getColumn(oldColumn).getDataType();
            column = column.copy(fieldType);
        }
        return this.applyModifyColumn(schema, oldColumnIndex, column, changeColumnEvent.isFirst(), changeColumnEvent.getAfterColumn());
    }

    private TableSchema applyModifyColumn(TableSchema schema, int columnIndex, Column column, boolean first, String afterColumn) {
        LinkedList<Column> originColumns = new LinkedList<Column>(schema.getColumns());
        if (first) {
            originColumns.remove(columnIndex);
            originColumns.addFirst(column);
        } else if (afterColumn != null) {
            originColumns.remove(columnIndex);
            int index = originColumns.stream().filter(c -> c.getName().equals(afterColumn)).findFirst().map(originColumns::indexOf).get();
            originColumns.add(index + 1, column);
        } else {
            originColumns.set(columnIndex, column);
        }
        return TableSchema.builder().columns(originColumns).primaryKey(schema.getPrimaryKey()).constraintKey(schema.getConstraintKeys()).build();
    }
}

