/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.schema.event;

import org.apache.seatunnel.api.event.EventType;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;

public class AlterTableModifyColumnEvent
extends AlterTableColumnEvent {
    private final Column column;
    private final boolean first;
    private final String afterColumn;

    public AlterTableModifyColumnEvent(TableIdentifier tableIdentifier, Column column, boolean first, String afterColumn) {
        super(tableIdentifier);
        this.column = column;
        this.first = first;
        this.afterColumn = afterColumn;
    }

    public static AlterTableModifyColumnEvent modifyFirst(TableIdentifier tableIdentifier, Column column) {
        return new AlterTableModifyColumnEvent(tableIdentifier, column, true, null);
    }

    public static AlterTableModifyColumnEvent modify(TableIdentifier tableIdentifier, Column column) {
        return new AlterTableModifyColumnEvent(tableIdentifier, column, false, null);
    }

    public static AlterTableModifyColumnEvent modifyAfter(TableIdentifier tableIdentifier, Column column, String afterColumn) {
        return new AlterTableModifyColumnEvent(tableIdentifier, column, false, afterColumn);
    }

    @Override
    public EventType getEventType() {
        return EventType.SCHEMA_CHANGE_MODIFY_COLUMN;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String getAfterColumn() {
        return this.afterColumn;
    }

    @Override
    public String toString() {
        return "AlterTableModifyColumnEvent(super=" + super.toString() + ", column=" + this.getColumn() + ", first=" + this.isFirst() + ", afterColumn=" + this.getAfterColumn() + ")";
    }
}

