/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;

public final class SeaTunnelRow
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String tableId = "";
    private RowKind kind = RowKind.INSERT;
    private final Object[] fields;
    private volatile int size;

    public SeaTunnelRow(int arity) {
        this.fields = new Object[arity];
    }

    public SeaTunnelRow(Object[] fields) {
        this.fields = fields;
    }

    public void setField(int pos, Object value) {
        this.fields[pos] = value;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setRowKind(RowKind kind) {
        this.kind = kind;
    }

    public int getArity() {
        return this.fields.length;
    }

    public String getTableId() {
        return this.tableId;
    }

    public RowKind getRowKind() {
        return this.kind;
    }

    public Object[] getFields() {
        return this.fields;
    }

    public Object getField(int pos) {
        return this.fields[pos];
    }

    public SeaTunnelRow copy() {
        Object[] newFields = new Object[this.getArity()];
        System.arraycopy(this.getFields(), 0, newFields, 0, newFields.length);
        SeaTunnelRow newRow = new SeaTunnelRow(newFields);
        newRow.setRowKind(this.getRowKind());
        newRow.setTableId(this.getTableId());
        return newRow;
    }

    public SeaTunnelRow copy(int[] indexMapping) {
        Object[] newFields = new Object[indexMapping.length];
        for (int i = 0; i < indexMapping.length; ++i) {
            newFields[i] = this.fields[indexMapping[i]];
        }
        SeaTunnelRow newRow = new SeaTunnelRow(newFields);
        newRow.setRowKind(this.getRowKind());
        newRow.setTableId(this.getTableId());
        return newRow;
    }

    public boolean isNullAt(int pos) {
        return this.fields[pos] == null;
    }

    public int getBytesSize(SeaTunnelRowType rowType) {
        if (this.size == 0) {
            int s = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                s += this.getBytesForValue(this.fields[i], rowType.getFieldType(i));
            }
            this.size = s;
        }
        return this.size;
    }

    private int getBytesForValue(Object v, SeaTunnelDataType<?> dataType) {
        if (v == null) {
            return 0;
        }
        SqlType sqlType = dataType.getSqlType();
        switch (sqlType) {
            case STRING: {
                return ((String)v).length();
            }
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case BIGINT: 
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 36;
            }
            case NULL: {
                return 0;
            }
            case BYTES: {
                return ((byte[])v).length;
            }
            case DATE: {
                return 24;
            }
            case TIME: {
                return 12;
            }
            case TIMESTAMP: {
                return 48;
            }
            case FLOAT_VECTOR: {
                return this.getArrayNotNullSize((Object[])v) * 4;
            }
            case ARRAY: {
                SeaTunnelDataType elementType = ((ArrayType)dataType).getElementType();
                if (elementType instanceof DecimalType) {
                    return ((Object[])v).length * 36;
                }
                if (elementType instanceof LocalTimeType) {
                    SqlType eleSqlType = elementType.getSqlType();
                    switch (eleSqlType) {
                        case DATE: {
                            return ((Object[])v).length * 24;
                        }
                        case TIME: {
                            return ((Object[])v).length * 12;
                        }
                        case TIMESTAMP: {
                            return ((Object[])v).length * 48;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported type in LocalTimeArrayType: " + (Object)((Object)eleSqlType));
                }
                return this.getBytesForArray(v, ((ArrayType)dataType).getElementType());
            }
            case MAP: {
                int size = 0;
                MapType mapType = (MapType)dataType;
                for (Map.Entry entry : ((Map)v).entrySet()) {
                    size += this.getBytesForValue(entry.getKey(), mapType.getKeyType()) + this.getBytesForValue(entry.getValue(), mapType.getValueType());
                }
                return size;
            }
            case ROW: {
                int rowSize = 0;
                SeaTunnelRowType rowType = (SeaTunnelRowType)dataType;
                SeaTunnelDataType<?>[] types = rowType.getFieldTypes();
                SeaTunnelRow row = (SeaTunnelRow)v;
                for (int i = 0; i < types.length; ++i) {
                    rowSize += this.getBytesForValue(row.fields[i], types[i]);
                }
                return rowSize;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)sqlType));
    }

    private int getBytesForArray(Object v, SeaTunnelDataType<?> dataType) {
        switch (dataType.getSqlType()) {
            case STRING: {
                int s = 0;
                for (String i : (String[])v) {
                    s += i == null ? 0 : i.length();
                }
                return s;
            }
            case BOOLEAN: {
                return this.getArrayNotNullSize((Boolean[])v);
            }
            case TINYINT: {
                return this.getArrayNotNullSize((Byte[])v);
            }
            case SMALLINT: {
                return this.getArrayNotNullSize((Short[])v) * 2;
            }
            case INT: {
                return this.getArrayNotNullSize((Integer[])v) * 4;
            }
            case FLOAT: {
                return this.getArrayNotNullSize((Float[])v) * 4;
            }
            case BIGINT: {
                return this.getArrayNotNullSize((Long[])v) * 8;
            }
            case DOUBLE: {
                return this.getArrayNotNullSize((Double[])v) * 8;
            }
        }
        return 0;
    }

    private int getArrayNotNullSize(Object[] values) {
        int c = 0;
        for (Object value : values) {
            if (value == null) continue;
            ++c;
        }
        return c;
    }

    public int getBytesSize() {
        if (this.size == 0) {
            int s = 0;
            for (Object field : this.fields) {
                s += this.getBytesForValue(field);
            }
            this.size = s;
        }
        return this.size;
    }

    private int getBytesForValue(Object v) {
        String clazz;
        if (v == null) {
            return 0;
        }
        switch (clazz = v.getClass().getSimpleName()) {
            case "String": {
                return ((String)v).length();
            }
            case "Boolean": 
            case "Byte": {
                return 1;
            }
            case "Short": {
                return 2;
            }
            case "Integer": 
            case "Float": {
                return 4;
            }
            case "Long": 
            case "Double": {
                return 8;
            }
            case "BigDecimal": {
                return 36;
            }
            case "byte[]": {
                return ((byte[])v).length;
            }
            case "LocalDate": {
                return 24;
            }
            case "LocalTime": {
                return 12;
            }
            case "LocalDateTime": {
                return 48;
            }
            case "String[]": {
                return this.getBytesForArray(v, BasicType.STRING_TYPE);
            }
            case "Boolean[]": {
                return this.getBytesForArray(v, BasicType.BOOLEAN_TYPE);
            }
            case "Byte[]": {
                return this.getBytesForArray(v, BasicType.BYTE_TYPE);
            }
            case "Short[]": {
                return this.getBytesForArray(v, BasicType.SHORT_TYPE);
            }
            case "Integer[]": {
                return this.getBytesForArray(v, BasicType.INT_TYPE);
            }
            case "Long[]": {
                return this.getBytesForArray(v, BasicType.LONG_TYPE);
            }
            case "Float[]": {
                return this.getBytesForArray(v, BasicType.FLOAT_TYPE);
            }
            case "Double[]": {
                return this.getBytesForArray(v, BasicType.DOUBLE_TYPE);
            }
            case "HashMap": 
            case "LinkedHashMap": {
                int size = 0;
                for (Map.Entry entry : ((Map)v).entrySet()) {
                    size += this.getBytesForValue(entry.getKey()) + this.getBytesForValue(entry.getValue());
                }
                return size;
            }
            case "SeaTunnelRow": {
                int rowSize = 0;
                SeaTunnelRow row = (SeaTunnelRow)v;
                for (int i = 0; i < row.fields.length; ++i) {
                    rowSize += this.getBytesForValue(row.fields[i]);
                }
                return rowSize;
            }
        }
        if (v instanceof Map) {
            int mapSize = 0;
            for (Map.Entry entry : ((Map)v).entrySet()) {
                mapSize += this.getBytesForValue(entry.getKey()) + this.getBytesForValue(entry.getValue());
            }
            return mapSize;
        }
        throw new UnsupportedOperationException("Unsupported type: " + clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeaTunnelRow)) {
            return false;
        }
        SeaTunnelRow that = (SeaTunnelRow)o;
        return Objects.equals(this.tableId, that.tableId) && this.kind == that.kind && Arrays.deepEquals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.tableId, this.kind});
        result = 31 * result + Arrays.deepHashCode(this.fields);
        return result;
    }

    public String toString() {
        return "SeaTunnelRow{tableId=" + this.tableId + ", kind=" + this.kind.shortString() + ", fields=" + Arrays.toString(this.fields) + '}';
    }
}

