/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCFunction<T, R>
implements Function<T, R> {
    private final Supplier<MDCContext> contextSupplier;
    protected final Function<T, R> delegate;

    public MDCFunction(Function<T, R> delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCFunction(MDCContext context, Function<T, R> delegate) {
        this(() -> context, delegate);
    }

    public MDCFunction(Supplier<MDCContext> contextSupplier, Function<T, R> delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public R apply(T t) {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            R r = this.delegate.apply(t);
            return r;
        }
    }
}

