/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

public class LocalTimeType<T extends Temporal>
implements SeaTunnelDataType<T> {
    private static final long serialVersionUID = 2L;
    public static final LocalTimeType<LocalDate> LOCAL_DATE_TYPE = new LocalTimeType<LocalDate>(LocalDate.class, SqlType.DATE);
    public static final LocalTimeType<LocalTime> LOCAL_TIME_TYPE = new LocalTimeType<LocalTime>(LocalTime.class, SqlType.TIME);
    public static final LocalTimeType<LocalDateTime> LOCAL_DATE_TIME_TYPE = new LocalTimeType<LocalDateTime>(LocalDateTime.class, SqlType.TIMESTAMP);
    public static final LocalTimeType<OffsetDateTime> OFFSET_DATE_TIME_TYPE = new LocalTimeType<OffsetDateTime>(OffsetDateTime.class, SqlType.TIMESTAMP_TZ);
    private final Class<T> typeClass;
    private final SqlType sqlType;

    private LocalTimeType(Class<T> typeClass, SqlType sqlType) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public int hashCode() {
        return Objects.hash(this.typeClass);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalTimeType)) {
            return false;
        }
        LocalTimeType that = (LocalTimeType)obj;
        return Objects.equals(this.typeClass, that.typeClass);
    }

    public String toString() {
        return this.sqlType.toString();
    }
}

