/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.AbstractSchema;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;

public final class TableSchema
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private final PrimaryKey primaryKey;
    private final List<ConstraintKey> constraintKeys;

    public TableSchema(List<Column> columns, PrimaryKey primaryKey, List<ConstraintKey> constraintKeys) {
        super(columns);
        this.primaryKey = primaryKey;
        this.constraintKeys = constraintKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TableSchema copy() {
        List<Column> copyColumns = this.columns.stream().map(Column::copy).collect(Collectors.toList());
        List<ConstraintKey> copyConstraintKeys = this.constraintKeys.stream().map(ConstraintKey::copy).collect(Collectors.toList());
        return TableSchema.builder().constraintKey(copyConstraintKeys).columns(copyColumns).primaryKey(this.primaryKey == null ? null : this.primaryKey.copy()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSchema)) {
            return false;
        }
        TableSchema other = (TableSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrimaryKey this$primaryKey = this.getPrimaryKey();
        PrimaryKey other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        List<ConstraintKey> this$constraintKeys = this.getConstraintKeys();
        List<ConstraintKey> other$constraintKeys = other.getConstraintKeys();
        return !(this$constraintKeys == null ? other$constraintKeys != null : !((Object)this$constraintKeys).equals(other$constraintKeys));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableSchema;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        List<ConstraintKey> $constraintKeys = this.getConstraintKeys();
        result = result * 59 + ($constraintKeys == null ? 43 : ((Object)$constraintKeys).hashCode());
        return result;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ConstraintKey> getConstraintKeys() {
        return this.constraintKeys;
    }

    @Override
    public String toString() {
        return "TableSchema(primaryKey=" + this.getPrimaryKey() + ", constraintKeys=" + this.getConstraintKeys() + ")";
    }

    public static final class Builder {
        private final List<Column> columns = new ArrayList<Column>();
        private PrimaryKey primaryKey;
        private final List<ConstraintKey> constraintKeys = new ArrayList<ConstraintKey>();

        public Builder columns(List<Column> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder column(Column column) {
            this.columns.add(column);
            return this;
        }

        public Builder primaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder constraintKey(ConstraintKey constraintKey) {
            this.constraintKeys.add(constraintKey);
            return this;
        }

        public Builder constraintKey(List<ConstraintKey> constraintKeys) {
            this.constraintKeys.addAll(constraintKeys);
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this.columns, this.primaryKey, this.constraintKeys);
        }
    }
}

