/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;

public interface Catalog
extends AutoCloseable {
    default public Optional<Factory> getFactory() {
        return Optional.empty();
    }

    public void open() throws CatalogException;

    @Override
    public void close() throws CatalogException;

    public String name();

    public String getDefaultDatabase() throws CatalogException;

    public boolean databaseExists(String var1) throws CatalogException;

    public List<String> listDatabases() throws CatalogException;

    public List<String> listTables(String var1) throws CatalogException, DatabaseNotExistException;

    public boolean tableExists(TablePath var1) throws CatalogException;

    public CatalogTable getTable(TablePath var1) throws CatalogException, TableNotExistException;

    default public CatalogTable getTable(TablePath tablePath, List<String> fieldNames) throws CatalogException, TableNotExistException {
        throw CommonError.unsupportedOperation((String)this.name(), (String)("get table with tablePath " + tablePath + ", fieldNames: " + fieldNames));
    }

    default public List<CatalogTable> getTables(ReadonlyConfig config) throws CatalogException {
        List tableNames = (List)config.get(ConnectorCommonOptions.TABLE_NAMES);
        if (tableNames != null && !tableNames.isEmpty()) {
            Iterator<TablePath> tablePaths = tableNames.stream().map(TablePath::of).filter(this::tableExists).iterator();
            return this.buildCatalogTablesWithErrorCheck(tablePaths);
        }
        String tablePatternStr = (String)config.get(ConnectorCommonOptions.TABLE_PATTERN);
        if (StringUtils.isBlank((CharSequence)tablePatternStr)) {
            return Collections.emptyList();
        }
        Pattern databasePattern = Pattern.compile((String)config.get(ConnectorCommonOptions.DATABASE_PATTERN));
        Pattern tablePattern = Pattern.compile((String)config.get(ConnectorCommonOptions.TABLE_PATTERN));
        List<String> allDatabase = this.listDatabases();
        allDatabase.removeIf(s -> !databasePattern.matcher((CharSequence)s).matches());
        ArrayList tablePaths = new ArrayList();
        for (String databaseName : allDatabase) {
            List<TablePath> paths = this.listTablePaths(databaseName);
            tablePaths.addAll(paths.stream().filter(path -> tablePattern.matcher(path.getDatabaseName() + "." + path.getSchemaAndTableName()).matches()).collect(Collectors.toList()));
        }
        return this.buildCatalogTablesWithErrorCheck(tablePaths.iterator());
    }

    default public List<TablePath> listTablePaths(String databaseName) throws CatalogException, DatabaseNotExistException {
        List<String> tableNames = this.listTables(databaseName);
        return tableNames.stream().map(tableName -> {
            String[] parts = tableName.split("\\.");
            if (parts.length > 1) {
                return TablePath.of(databaseName, parts[0], parts[1]);
            }
            return TablePath.of(databaseName, null, tableName);
        }).collect(Collectors.toList());
    }

    default public List<CatalogTable> buildCatalogTablesWithErrorCheck(Iterator<TablePath> tablePaths) {
        LinkedHashMap unsupportedTable = new LinkedHashMap();
        ArrayList<CatalogTable> catalogTables = new ArrayList<CatalogTable>();
        while (tablePaths.hasNext()) {
            try {
                catalogTables.add(this.getTable(tablePaths.next()));
            }
            catch (SeaTunnelRuntimeException e) {
                if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.GET_CATALOG_TABLE_WITH_UNSUPPORTED_TYPE_ERROR)) {
                    unsupportedTable.put(e.getParams().get("tableName"), e.getParamsValueAsMap("fieldWithDataTypes"));
                    continue;
                }
                throw e;
            }
        }
        if (!unsupportedTable.isEmpty()) {
            throw CommonError.getCatalogTablesWithUnsupportedType((String)this.name(), unsupportedTable);
        }
        return catalogTables;
    }

    default public <T> void buildColumnsWithErrorCheck(TablePath tablePath, TableSchema.Builder builder, Iterator<T> keys, Function<T, Column> getColumn) {
        LinkedHashMap unsupported = new LinkedHashMap();
        while (keys.hasNext()) {
            try {
                builder.column(getColumn.apply(keys.next()));
            }
            catch (SeaTunnelRuntimeException e) {
                if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE)) {
                    unsupported.put(e.getParams().get("field"), e.getParams().get("dataType"));
                    continue;
                }
                throw e;
            }
        }
        if (!unsupported.isEmpty()) {
            throw CommonError.getCatalogTableWithUnsupportedType((String)this.name(), (String)tablePath.getFullName(), unsupported);
        }
    }

    public void createTable(TablePath var1, CatalogTable var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException;

    default public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists, boolean createIndex) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.createTable(tablePath, table, ignoreIfExists);
    }

    public void dropTable(TablePath var1, boolean var2) throws TableNotExistException, CatalogException;

    public void createDatabase(TablePath var1, boolean var2) throws DatabaseAlreadyExistException, CatalogException;

    public void dropDatabase(TablePath var1, boolean var2) throws DatabaseNotExistException, CatalogException;

    default public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
    }

    default public boolean isExistsData(TablePath tablePath) {
        return false;
    }

    default public void executeSql(TablePath tablePath, String sql) {
    }

    default public PreviewResult previewAction(ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        throw new UnsupportedOperationException("Preview action is not supported");
    }

    public static enum ActionType {
        CREATE_TABLE,
        CREATE_DATABASE,
        DROP_TABLE,
        DROP_DATABASE,
        TRUNCATE_TABLE;

    }
}

