/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.seatunnel.api.tracing.MDCContext;

public class MDCConsumer<T>
implements Consumer<T> {
    private final Supplier<MDCContext> contextSupplier;
    private final Consumer<T> delegate;

    public MDCConsumer(Consumer<T> delegate) {
        this(MDCContext.current(), delegate);
    }

    public MDCConsumer(MDCContext context, Consumer<T> delegate) {
        this(() -> context, delegate);
    }

    public MDCConsumer(Supplier<MDCContext> contextSupplier, Consumer<T> delegate) {
        this.contextSupplier = contextSupplier;
        this.delegate = delegate;
    }

    @Override
    public void accept(T t) {
        try (MDCContext ignored = this.contextSupplier.get().activate();){
            this.delegate.accept(t);
        }
    }
}

