/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.factory;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.common.utils.SeaTunnelException;

public abstract class TableFactoryContext {
    private final ReadonlyConfig options;
    private final ClassLoader classLoader;

    public TableFactoryContext(ReadonlyConfig options, ClassLoader classLoader) {
        this.options = options;
        this.classLoader = classLoader;
    }

    protected static void checkCatalogTableIllegal(List<CatalogTable> catalogTables) {
        for (CatalogTable catalogTable : catalogTables) {
            ArrayList<String> alreadyChecked = new ArrayList<String>();
            for (String fieldName : catalogTable.getTableSchema().getFieldNames()) {
                if (StringUtils.isBlank((CharSequence)fieldName)) {
                    throw new SeaTunnelException(String.format("Table %s field name cannot be empty", catalogTable.getTablePath().getFullName()));
                }
                if (alreadyChecked.contains(fieldName)) {
                    throw new SeaTunnelException(String.format("Table %s field %s duplicate", catalogTable.getTablePath().getFullName(), fieldName));
                }
                alreadyChecked.add(fieldName);
            }
        }
    }

    public ReadonlyConfig getOptions() {
        return this.options;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

