/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.factory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.ChangeStreamTableSourceCheckpoint;
import org.apache.seatunnel.api.table.factory.ChangeStreamTableSourceState;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;

public interface ChangeStreamTableSourceFactory
extends TableSourceFactory {
    default public <SplitT extends SourceSplit> Serializer<SplitT> getSplitSerializer() {
        return new DefaultSerializer();
    }

    default public <StateT extends Serializable> Serializer<StateT> getEnumeratorStateSerializer() {
        return new DefaultSerializer();
    }

    default public <StateT extends Serializable, SplitT extends SourceSplit> ChangeStreamTableSourceState<StateT, SplitT> deserializeTableSourceState(ChangeStreamTableSourceCheckpoint checkpoint) throws IOException {
        Serializable enumeratorState = null;
        if (checkpoint.getEnumeratorState() != null) {
            Serializer<StateT> enumeratorStateSerializer = this.getEnumeratorStateSerializer();
            enumeratorState = (Serializable)enumeratorStateSerializer.deserialize(checkpoint.getEnumeratorState());
        }
        ArrayList deserializedSplits = new ArrayList();
        if (checkpoint.getSplits() != null && !checkpoint.getSplits().isEmpty()) {
            Serializer<SplitT> splitSerializer = this.getSplitSerializer();
            List<List<byte[]>> splits = checkpoint.getSplits();
            for (int i = 0; i < splits.size(); ++i) {
                List<byte[]> subTaskSplits = splits.get(i);
                if (subTaskSplits == null || subTaskSplits.isEmpty()) {
                    deserializedSplits.add(Collections.emptyList());
                    continue;
                }
                ArrayList<SourceSplit> deserializedSubTaskSplits = new ArrayList<SourceSplit>(subTaskSplits.size());
                for (byte[] split : subTaskSplits) {
                    if (split == null) continue;
                    deserializedSubTaskSplits.add((SourceSplit)splitSerializer.deserialize(split));
                }
                deserializedSplits.add(deserializedSubTaskSplits);
            }
        }
        return new ChangeStreamTableSourceState(enumeratorState, deserializedSplits);
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> restoreSource(TableSourceFactoryContext var1, ChangeStreamTableSourceState<StateT, SplitT> var2);
}

