/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;

public class VectorIndex
extends ConstraintKey.ConstraintKeyColumn
implements Serializable {
    private final String indexName;
    private final IndexType indexType;
    private final MetricType metricType;

    public VectorIndex(String indexName, String columnName, String indexType, String metricType) {
        super(columnName, null);
        this.indexName = indexName;
        this.indexType = IndexType.of(indexType);
        this.metricType = MetricType.of(metricType);
    }

    public VectorIndex(String indexName, String columnName, IndexType indexType, MetricType metricType) {
        super(columnName, null);
        this.indexName = indexName;
        this.indexType = indexType;
        this.metricType = metricType;
    }

    @Override
    public ConstraintKey.ConstraintKeyColumn copy() {
        return new VectorIndex(this.indexName, this.getColumnName(), this.indexType, this.metricType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorIndex)) {
            return false;
        }
        VectorIndex other = (VectorIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        IndexType this$indexType = this.getIndexType();
        IndexType other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType)) {
            return false;
        }
        MetricType this$metricType = this.getMetricType();
        MetricType other$metricType = other.getMetricType();
        return !(this$metricType == null ? other$metricType != null : !((Object)((Object)this$metricType)).equals((Object)other$metricType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VectorIndex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        IndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
        MetricType $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : ((Object)((Object)$metricType)).hashCode());
        return result;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public static enum IndexType {
        FLAT,
        IVF_FLAT,
        IVF_SQ8,
        IVF_PQ,
        HNSW,
        DISKANN,
        AUTOINDEX,
        SCANN,
        GPU_IVF_FLAT,
        GPU_IVF_PQ,
        GPU_BRUTE_FORCE,
        GPU_CAGRA,
        BIN_FLAT,
        BIN_IVF_FLAT,
        TRIE,
        STL_SORT,
        INVERTED,
        SPARSE_INVERTED_INDEX,
        SPARSE_WAND;


        public static IndexType of(String name) {
            return IndexType.valueOf(name.toUpperCase());
        }
    }

    public static enum MetricType {
        L2,
        IP,
        COSINE,
        HAMMING,
        JACCARD;


        public static MetricType of(String name) {
            return MetricType.valueOf(name.toUpperCase());
        }
    }
}

