/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.internal;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbSingleCollectionProvider
implements MongodbClientProvider {
    private static final Logger log = LoggerFactory.getLogger(MongodbSingleCollectionProvider.class);
    private final String connectionString;
    private final String defaultDatabase;
    private final String defaultCollection;
    private MongoClient client;
    private MongoDatabase database;
    private MongoCollection<BsonDocument> collection;

    public MongodbSingleCollectionProvider(String connectionString, String defaultDatabase, String defaultCollection) {
        Preconditions.checkNotNull((Object)connectionString);
        Preconditions.checkNotNull((Object)defaultDatabase);
        Preconditions.checkNotNull((Object)defaultCollection);
        this.connectionString = connectionString;
        this.defaultDatabase = defaultDatabase;
        this.defaultCollection = defaultCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoClient getClient() {
        MongodbSingleCollectionProvider mongodbSingleCollectionProvider = this;
        synchronized (mongodbSingleCollectionProvider) {
            if (this.client == null) {
                this.client = MongoClients.create(this.connectionString);
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoDatabase getDefaultDatabase() {
        MongodbSingleCollectionProvider mongodbSingleCollectionProvider = this;
        synchronized (mongodbSingleCollectionProvider) {
            if (this.database == null) {
                this.database = this.getClient().getDatabase(this.defaultDatabase);
            }
        }
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoCollection<BsonDocument> getDefaultCollection() {
        MongodbSingleCollectionProvider mongodbSingleCollectionProvider = this;
        synchronized (mongodbSingleCollectionProvider) {
            if (this.collection == null) {
                this.collection = this.getDefaultDatabase().getCollection(this.defaultCollection, BsonDocument.class);
            }
        }
        return this.collection;
    }

    @Override
    public void close() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            log.error("Failed to close Mongo client", (Throwable)e);
        }
        finally {
            this.client = null;
        }
    }
}

