/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.protobuf;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.protobuf.CompileDescriptor;
import org.apache.seatunnel.format.protobuf.RowToProtobufConverter;

public class ProtobufSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 4438784443025715370L;
    private final RowToProtobufConverter converter;

    public ProtobufSerializationSchema(SeaTunnelRowType rowType, String protobufMessageName, String protobufSchema) {
        try {
            Descriptors.Descriptor descriptor = CompileDescriptor.compileDescriptorTempFile(protobufSchema, protobufMessageName);
            this.converter = new RowToProtobufConverter(rowType, descriptor);
        }
        catch (Descriptors.DescriptorValidationException | IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serialize(SeaTunnelRow element) {
        return this.converter.convertRowToGenericRecord(element);
    }
}

