/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kafka.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.KafkaSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.StartMode;
import org.apache.seatunnel.connectors.seatunnel.kafka.source.KafkaSource;

@AutoService(value={Factory.class})
public class KafkaSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Kafka";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{KafkaSourceOptions.BOOTSTRAP_SERVERS}).exclusive(new Option[]{KafkaSourceOptions.TOPIC, KafkaSourceOptions.TABLE_CONFIGS, KafkaSourceOptions.TABLE_LIST}).optional(new Option[]{KafkaSourceOptions.START_MODE, KafkaSourceOptions.PATTERN, KafkaSourceOptions.CONSUMER_GROUP, KafkaSourceOptions.COMMIT_ON_CHECKPOINT, KafkaSourceOptions.KAFKA_CONFIG, KafkaSourceOptions.SCHEMA, KafkaSourceOptions.FORMAT, KafkaSourceOptions.DEBEZIUM_RECORD_INCLUDE_SCHEMA, KafkaSourceOptions.DEBEZIUM_RECORD_TABLE_FILTER, KafkaSourceOptions.KEY_PARTITION_DISCOVERY_INTERVAL_MILLIS, KafkaSourceOptions.READER_CACHE_QUEUE_SIZE}).conditional(KafkaSourceOptions.START_MODE, (Object)StartMode.TIMESTAMP, new Option[]{KafkaSourceOptions.START_MODE_TIMESTAMP}).conditional(KafkaSourceOptions.START_MODE, (Object)StartMode.SPECIFIC_OFFSETS, new Option[]{KafkaSourceOptions.START_MODE_OFFSETS}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new KafkaSource(context.getOptions());
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return KafkaSource.class;
    }
}

