/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc;

import com.github.dockerjava.api.model.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.InsecureURLClassLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.JdbcCase;
import org.apache.seatunnel.connectors.seatunnel.jdbc.JdbcITErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.iris.IrisCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcCatalogUtils;
import org.apache.seatunnel.e2e.common.TestResource;
import org.apache.seatunnel.e2e.common.TestSuiteBase;
import org.apache.seatunnel.e2e.common.container.ContainerExtendedFactory;
import org.apache.seatunnel.e2e.common.container.TestContainer;
import org.apache.seatunnel.e2e.common.junit.TestContainerExtension;
import org.apache.seatunnel.shade.com.google.common.io.ByteStreams;
import org.apache.seatunnel.shade.com.google.common.io.CharStreams;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.lifecycle.Startables;

public abstract class AbstractJdbcIT
extends TestSuiteBase
implements TestResource {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String HOST = "HOST";
    @TestContainerExtension
    protected final ContainerExtendedFactory extendedFactory = container -> {
        Container.ExecResult extraCommands = container.execInContainer(new String[]{"bash", "-c", "mkdir -p /tmp/seatunnel/plugins/Jdbc/lib && cd /tmp/seatunnel/plugins/Jdbc/lib && wget " + this.driverUrl() + " --no-check-certificate"});
        Assertions.assertEquals((int)0, (int)extraCommands.getExitCode(), (String)extraCommands.getStderr());
    };
    protected GenericContainer<?> dbServer;
    protected JdbcCase jdbcCase;
    protected Connection connection;
    protected Catalog catalog;
    protected URLClassLoader urlClassLoader;

    abstract JdbcCase getJdbcCase();

    void checkResult(String executeKey, TestContainer container, Container.ExecResult execResult) {
    }

    abstract String driverUrl();

    abstract Pair<String[], List<SeaTunnelRow>> initTestData();

    abstract GenericContainer<?> initContainer();

    protected URLClassLoader getUrlClassLoader() throws MalformedURLException {
        if (this.urlClassLoader == null) {
            this.urlClassLoader = new InsecureURLClassLoader(new URL[]{new URL(this.driverUrl())}, AbstractJdbcIT.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(this.urlClassLoader);
        }
        return this.urlClassLoader;
    }

    protected Class<?> loadDriverClassFromUrl() {
        try {
            return this.getUrlClassLoader().loadClass(this.jdbcCase.getDriverClass());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load driver class: " + this.jdbcCase.getDriverClass(), e);
        }
    }

    protected Class<?> loadDriverClass() {
        try {
            return Class.forName(this.jdbcCase.getDriverClass());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load driver class: " + this.jdbcCase.getDriverClass(), e);
        }
    }

    protected void initializeJdbcConnection(String jdbcUrl) throws SQLException, InstantiationException, IllegalAccessException {
        Driver driver = (Driver)this.loadDriverClass().newInstance();
        Properties props = new Properties();
        if (StringUtils.isNotBlank((CharSequence)this.jdbcCase.getUserName())) {
            props.put("user", this.jdbcCase.getUserName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.jdbcCase.getPassword())) {
            props.put("password", this.jdbcCase.getPassword());
        }
        if (this.dbServer != null) {
            jdbcUrl = jdbcUrl.replace(HOST, this.dbServer.getHost());
        }
        this.connection = driver.connect(jdbcUrl, props);
        this.connection.setAutoCommit(false);
    }

    protected void insertTestData() {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.jdbcCase.getInsertSql());){
            List rows = (List)this.jdbcCase.getTestData().getValue();
            for (SeaTunnelRow row : rows) {
                for (int index = 0; index < row.getArity(); ++index) {
                    preparedStatement.setObject(index + 1, row.getField(index));
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            this.connection.commit();
        }
        catch (Exception exception) {
            this.log.error(ExceptionUtils.getMessage((Throwable)exception));
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)JdbcITErrorCode.INSERT_DATA_FAILED, (Throwable)exception);
        }
    }

    protected void createSchemaIfNeeded() {
    }

    protected void createNeededTables() {
        try (Statement statement = this.connection.createStatement();){
            String additionalSql;
            String createTemplate = this.jdbcCase.getCreateSql();
            String createSource = String.format(createTemplate, this.buildTableInfoWithSchema(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSourceTable()));
            statement.execute(createSource);
            if (this.jdbcCase.getAdditionalSqlOnSource() != null) {
                additionalSql = String.format(this.jdbcCase.getAdditionalSqlOnSource(), this.buildTableInfoWithSchema(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSourceTable()));
                statement.execute(additionalSql);
            }
            if (!this.jdbcCase.isUseSaveModeCreateTable()) {
                if (this.jdbcCase.getSinkCreateSql() != null) {
                    createTemplate = this.jdbcCase.getSinkCreateSql();
                }
                String createSink = String.format(createTemplate, this.buildTableInfoWithSchema(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSinkTable()));
                statement.execute(createSink);
            }
            if (this.jdbcCase.getAdditionalSqlOnSink() != null) {
                additionalSql = String.format(this.jdbcCase.getAdditionalSqlOnSink(), this.buildTableInfoWithSchema(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSinkTable()));
                statement.execute(additionalSql);
            }
            this.connection.commit();
        }
        catch (Exception exception) {
            this.log.error(ExceptionUtils.getMessage((Throwable)exception));
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)JdbcITErrorCode.CREATE_TABLE_FAILED, (Throwable)exception);
        }
    }

    public String insertTable(String schema, String table, String ... fields) {
        String columns = Arrays.stream(fields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fields).map(f -> "?").collect(Collectors.joining(", "));
        return "INSERT INTO " + this.buildTableInfoWithSchema(schema, table) + " (" + columns + " ) VALUES (" + placeholders + ")";
    }

    protected void clearTable(String database, String schema, String table) {
        this.clearTable(database, table);
    }

    protected String buildTableInfoWithSchema(String database, String schema, String table) {
        return this.buildTableInfoWithSchema(database, table);
    }

    public void clearTable(String schema, String table) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("TRUNCATE TABLE " + this.buildTableInfoWithSchema(schema, table));
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException exception) {
                throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)JdbcITErrorCode.CLEAR_TABLE_FAILED, (Throwable)exception);
            }
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)JdbcITErrorCode.CLEAR_TABLE_FAILED, (Throwable)e);
        }
    }

    public String quoteIdentifier(String field) {
        return "`" + field + "`";
    }

    public String buildTableInfoWithSchema(String schema, String table) {
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            return this.quoteIdentifier(schema) + "." + this.quoteIdentifier(table);
        }
        return this.quoteIdentifier(table);
    }

    @BeforeAll
    public void startUp() {
        this.dbServer = this.initContainer().withImagePullPolicy(PullPolicy.alwaysPull());
        Startables.deepStart(Stream.of(this.dbServer)).join();
        this.jdbcCase = this.getJdbcCase();
        this.beforeStartUP();
        Awaitility.given().ignoreExceptions().await().atMost(360L, TimeUnit.SECONDS).untilAsserted(() -> this.initializeJdbcConnection(this.jdbcCase.getJdbcUrl()));
        this.createSchemaIfNeeded();
        this.createNeededTables();
        this.insertTestData();
        this.initCatalog();
    }

    protected void beforeStartUP() {
    }

    @AfterAll
    public void tearDown() throws SQLException {
        if (this.catalog != null) {
            this.catalog.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.dbServer != null) {
            this.dbServer.close();
            String images = ((List)this.dockerClient.listImagesCmd().exec()).stream().map(Image::getId).collect(Collectors.joining(","));
            this.log.info("before remove image {}, list images: {}", (Object)this.dbServer.getDockerImageName(), (Object)images);
            try {
                this.dockerClient.removeImageCmd(this.dbServer.getDockerImageName()).exec();
            }
            catch (Exception ignored) {
                this.log.warn("Failed to delete the image. Another container may be in use", (Throwable)ignored);
            }
            images = ((List)this.dockerClient.listImagesCmd().exec()).stream().map(Image::getId).collect(Collectors.joining(","));
            this.log.info("after remove image {}, list images: {}", (Object)this.dbServer.getDockerImageName(), (Object)images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testJdbcDb(TestContainer container) throws IOException, InterruptedException, SQLException {
        List<String> configFiles = this.jdbcCase.getConfigFile();
        for (String configFile : configFiles) {
            try {
                Container.ExecResult execResult = container.executeJob(configFile);
                Assertions.assertEquals((int)0, (int)execResult.getExitCode(), (String)execResult.getStderr());
                this.checkResult(String.format("%s in [%s]", configFile, container.identifier()), container, execResult);
            }
            finally {
                this.clearTable(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSinkTable());
            }
        }
    }

    protected void initCatalog() {
    }

    @Test
    public void testCreateIndex() {
        if (this.catalog == null) {
            return;
        }
        TablePath sourceTablePath = new TablePath(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSourceTable());
        TablePath targetTablePath = new TablePath(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSinkTable() + (this.catalog instanceof OracleCatalog ? "_INDEX" : "_index"));
        boolean createdDb = false;
        if (!(this.catalog instanceof IrisCatalog) && !this.catalog.databaseExists(targetTablePath.getDatabaseName())) {
            this.catalog.createDatabase(targetTablePath, false);
            Assertions.assertTrue((boolean)this.catalog.databaseExists(targetTablePath.getDatabaseName()));
            createdDb = true;
        }
        CatalogTable catalogTable = this.catalog.getTable(sourceTablePath);
        this.createIndexOrNot(targetTablePath, catalogTable, false);
        Assertions.assertFalse((boolean)this.hasIndex(this.catalog, targetTablePath));
        this.dropTableWithAssert(targetTablePath);
        this.createIndexOrNot(targetTablePath, catalogTable, true);
        Assertions.assertTrue((boolean)this.hasIndex(this.catalog, targetTablePath));
        this.dropTableWithAssert(targetTablePath);
        if (createdDb) {
            this.catalog.dropDatabase(targetTablePath, false);
            Assertions.assertFalse((boolean)this.catalog.databaseExists(targetTablePath.getDatabaseName()));
        }
    }

    private boolean hasIndex(Catalog catalog, TablePath targetTablePath) {
        TableSchema tableSchema = catalog.getTable(targetTablePath).getTableSchema();
        PrimaryKey primaryKey = tableSchema.getPrimaryKey();
        List constraintKeys = tableSchema.getConstraintKeys();
        if (primaryKey != null && StringUtils.isNotBlank((CharSequence)primaryKey.getPrimaryKey())) {
            return true;
        }
        return !constraintKeys.isEmpty();
    }

    protected void dropTableWithAssert(TablePath targetTablePath) {
        this.catalog.dropTable(targetTablePath, true);
        Assertions.assertFalse((boolean)this.catalog.tableExists(targetTablePath));
    }

    protected void createIndexOrNot(TablePath targetTablePath, CatalogTable catalogTable, boolean createIndex) {
        this.catalog.createTable(targetTablePath, catalogTable, false, createIndex);
        Assertions.assertTrue((boolean)this.catalog.tableExists(targetTablePath));
    }

    @Test
    public void testCatalog() {
        Exception exception;
        if (this.catalog == null) {
            return;
        }
        TablePath sourceTablePath = new TablePath(this.jdbcCase.getDatabase(), this.jdbcCase.getSchema(), this.jdbcCase.getSourceTable());
        TablePath targetTablePath = new TablePath(this.jdbcCase.getCatalogDatabase(), this.jdbcCase.getCatalogSchema(), this.jdbcCase.getCatalogTable());
        boolean createdDb = false;
        if (!this.catalog.databaseExists(targetTablePath.getDatabaseName())) {
            this.catalog.createDatabase(targetTablePath, false);
            Assertions.assertTrue((boolean)this.catalog.databaseExists(targetTablePath.getDatabaseName()));
            createdDb = true;
        }
        CatalogTable catalogTable = this.catalog.getTable(sourceTablePath);
        this.catalog.createTable(targetTablePath, catalogTable, false);
        Assertions.assertTrue((boolean)this.catalog.tableExists(targetTablePath));
        this.catalog.dropTable(targetTablePath, false);
        Assertions.assertFalse((boolean)this.catalog.tableExists(targetTablePath));
        if (createdDb) {
            this.catalog.dropDatabase(targetTablePath, false);
            Assertions.assertFalse((boolean)this.catalog.databaseExists(targetTablePath.getDatabaseName()));
        }
        Assertions.assertTrue(((exception = (Exception)Assertions.assertThrows(Exception.class, () -> this.catalog.truncateTable(TablePath.of((String)"not_exist", (String)"not_exist", (String)"not_exist"), false))) instanceof TableNotExistException || exception instanceof CatalogException ? 1 : 0) != 0);
    }

    @Test
    public void testCatalogWithCatalogUtils() throws SQLException, ClassNotFoundException {
        if (StringUtils.isBlank((CharSequence)this.jdbcCase.getTablePathFullName())) {
            return;
        }
        ArrayList<JdbcSourceTableConfig> tablesConfig = new ArrayList<JdbcSourceTableConfig>();
        JdbcSourceTableConfig tableConfig = JdbcSourceTableConfig.builder().query("SELECT * FROM " + this.jdbcCase.getSourceTable()).useSelectCount(Boolean.valueOf(false)).build();
        tablesConfig.add(tableConfig);
        Map tables = JdbcCatalogUtils.getTables((JdbcConnectionConfig)JdbcConnectionConfig.builder().url(this.jdbcCase.getJdbcUrl().replace(HOST, this.dbServer.getHost())).driverName(this.jdbcCase.getDriverClass()).username(this.jdbcCase.getUserName()).password(this.jdbcCase.getPassword()).build(), tablesConfig);
        Set tablePaths = tables.keySet();
        tablePaths.forEach(tablePath -> {
            this.log.info("Expected: {} Actual: {}", (Object)tablePath.getFullName(), (Object)this.jdbcCase.getTablePathFullName());
            Assertions.assertTrue((boolean)tablePath.getFullName().equalsIgnoreCase(this.jdbcCase.getTablePathFullName()));
        });
    }

    protected Object[] toArrayResult(ResultSet resultSet, String[] fieldNames) throws SQLException, IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>(0);
        while (resultSet.next()) {
            Object[] rowArray = new Object[fieldNames.length];
            for (int colIndex = 0; colIndex < fieldNames.length; ++colIndex) {
                rowArray[colIndex] = this.checkData(resultSet.getObject(fieldNames[colIndex]));
            }
            result.add(rowArray);
        }
        return result.toArray();
    }

    private Object checkData(Object data) throws SQLException, IOException {
        if (data == null) {
            return null;
        }
        if (data instanceof byte[]) {
            return data;
        }
        if (data instanceof Clob) {
            try (Reader reader = ((Clob)data).getCharacterStream();){
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
        }
        if (data instanceof Blob) {
            try (InputStream inputStream = ((Blob)data).getBinaryStream();){
                byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
                return byArray;
            }
        }
        if (data instanceof InputStream) {
            try (InputStream inputStream = (InputStream)data;){
                byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
                return byArray;
            }
        }
        if (data instanceof Array) {
            Object[] jdbcArray = (Object[])((Array)data).getArray();
            Object[] javaArray = new Object[jdbcArray.length];
            for (int index = 0; index < jdbcArray.length; ++index) {
                javaArray[index] = this.checkData(jdbcArray[index]);
            }
            return javaArray;
        }
        return data;
    }

    protected void defaultCompare(String executeKey, String[] fieldNames, String sortKey) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet source = statement.executeQuery(String.format("SELECT * FROM %s ORDER BY %s", this.buildTableInfoWithSchema(this.jdbcCase.getSchema(), this.jdbcCase.getSourceTable()), this.quoteIdentifier(sortKey)));
            Object[] sourceResult = this.toArrayResult(source, fieldNames);
            ResultSet sink = statement.executeQuery(String.format("SELECT * FROM %s ORDER BY %s", this.buildTableInfoWithSchema(this.jdbcCase.getSchema(), this.jdbcCase.getSinkTable()), this.quoteIdentifier(sortKey)));
            Object[] sinkResult = this.toArrayResult(sink, fieldNames);
            this.log.warn("{}: source data count {}, sink data count {}.", new Object[]{executeKey, sourceResult.length, sinkResult.length});
            Assertions.assertArrayEquals((Object[])sourceResult, (Object[])sinkResult, (String)String.format("[%s] data compare", executeKey));
        }
        catch (IOException | SQLException e) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)JdbcITErrorCode.DATA_COMPARISON_FAILED, (Throwable)e);
        }
    }
}

