/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.firestore.sink;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.config.FirestoreParameters;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.exception.FirestoreConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.exception.FirestoreConnectorException;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.serialize.DefaultSeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.serialize.SeaTunnelRowSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirestoreSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(FirestoreSinkWriter.class);
    private Firestore firestore;
    private CollectionReference collectionReference;
    private SeaTunnelRowSerializer serializer;

    public FirestoreSinkWriter(SeaTunnelRowType seaTunnelRowType, FirestoreParameters parameters) throws IOException {
        GoogleCredentials credentials;
        if (parameters.getCredentials() != null) {
            byte[] bytes = Base64.getDecoder().decode(parameters.getCredentials());
            credentials = GoogleCredentials.fromStream(new ByteArrayInputStream(bytes));
        } else {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.getDefaultInstance().toBuilder().setProjectId(parameters.getProjectId())).setCredentials(credentials)).build();
        this.firestore = (Firestore)firestoreOptions.getService();
        this.collectionReference = this.firestore.collection(parameters.getCollection());
        this.serializer = new DefaultSeaTunnelRowSerializer(seaTunnelRowType);
    }

    public void write(SeaTunnelRow seaTunnelRow) throws IOException {
        this.collectionReference.add(this.serializer.serialize(seaTunnelRow));
    }

    public void close() throws IOException {
        if (this.firestore != null) {
            try {
                this.firestore.close();
            }
            catch (Exception e) {
                throw new FirestoreConnectorException(FirestoreConnectorErrorCode.CLOSE_CLIENT_FAILED, "Close Firestore client failed.", e);
            }
        }
    }
}

