/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.firestore.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.config.FirestoreParameters;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.sink.FirestoreSinkWriter;

public class FirestoreSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private final CatalogTable catalogTable;
    private final FirestoreParameters firestoreParameters;

    public FirestoreSink(CatalogTable catalogTable, FirestoreParameters firestoreParameters) {
        this.catalogTable = catalogTable;
        this.firestoreParameters = firestoreParameters;
    }

    public String getPluginName() {
        return "GoogleFirestore";
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new FirestoreSinkWriter(this.catalogTable.getSeaTunnelRowType(), this.firestoreParameters);
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

