/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.firestore.serialize;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.google.firestore.serialize.SeaTunnelRowSerializer;

public class DefaultSeaTunnelRowSerializer
implements SeaTunnelRowSerializer {
    private final SeaTunnelRowType seaTunnelRowType;

    public DefaultSeaTunnelRowSerializer(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    @Override
    public Map<String, Object> serialize(SeaTunnelRow seaTunnelRow) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int index = 0; index < this.seaTunnelRowType.getFieldNames().length; ++index) {
            SeaTunnelDataType fieldType = this.seaTunnelRowType.getFieldType(index);
            Object fieldValue = seaTunnelRow.getField(index);
            data.put(this.seaTunnelRowType.getFieldName(index), DefaultSeaTunnelRowSerializer.convert(fieldType, fieldValue));
        }
        return data;
    }

    private static Object convert(SeaTunnelDataType<?> seaTunnelDataType, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        switch (seaTunnelDataType.getSqlType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return ((Number)fieldValue).intValue();
            }
            case BIGINT: {
                return ((Number)fieldValue).longValue();
            }
            case FLOAT: {
                Float floatValue = (Float)fieldValue;
                return Double.parseDouble(String.valueOf(floatValue));
            }
            case DOUBLE: {
                return Double.parseDouble(String.valueOf(fieldValue));
            }
            case DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)fieldValue;
                return bigDecimal;
            }
            case STRING: {
                return String.valueOf(fieldValue);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(String.valueOf(fieldValue));
            }
            case BYTES: {
                return Blob.fromBytes((byte[])fieldValue);
            }
            case DATE: {
                LocalDate localDate = (LocalDate)fieldValue;
                return Date.from(localDate.atStartOfDay(ZoneOffset.UTC).toInstant());
            }
            case TIMESTAMP: {
                LocalDateTime localDateTime = (LocalDateTime)fieldValue;
                return Timestamp.of(Date.from(localDateTime.toInstant(ZoneOffset.UTC)));
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)seaTunnelDataType;
                Object[] array = (Object[])fieldValue;
                ArrayList<Object> listValues = new ArrayList<Object>();
                for (Object item : array) {
                    listValues.add(DefaultSeaTunnelRowSerializer.convert(arrayType.getElementType(), item));
                }
                return listValues;
            }
            case MAP: {
                MapType mapType = (MapType)seaTunnelDataType;
                Map map = (Map)fieldValue;
                for (Map.Entry entry : map.entrySet()) {
                    String mapKeyName = (String)entry.getKey();
                    map.put(mapKeyName, DefaultSeaTunnelRowSerializer.convert(mapType.getValueType(), entry.getValue()));
                }
                return map;
            }
        }
        return fieldValue;
    }
}

