/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import io.grpc.Internal;
import io.grpc.Status;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.security.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableList;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.ProtocolStringList;

@Internal
public abstract class DynamicSslContextProvider
extends SslContextProvider {
    protected final List<SslContextProvider.Callback> pendingCallbacks = new ArrayList<SslContextProvider.Callback>();
    @Nullable
    protected final CertificateValidationContext staticCertificateValidationContext;
    @Nullable
    protected SslContext sslContext;

    protected DynamicSslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateValidationContext staticCertValidationContext) {
        super(tlsContext);
        this.staticCertificateValidationContext = staticCertValidationContext;
    }

    @Nullable
    public SslContext getSslContext() {
        return this.sslContext;
    }

    protected abstract CertificateValidationContext generateCertificateValidationContext();

    protected abstract SslContextBuilder getSslContextBuilder(CertificateValidationContext var1) throws CertificateException, IOException, CertStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateSslContext() {
        try {
            List<SslContextProvider.Callback> pendingCallbacksCopy;
            SslContext sslContextCopy;
            CertificateValidationContext localCertValidationContext = this.generateCertificateValidationContext();
            SslContextBuilder sslContextBuilder = this.getSslContextBuilder(localCertValidationContext);
            CommonTlsContext commonTlsContext = this.getCommonTlsContext();
            if (commonTlsContext != null && commonTlsContext.getAlpnProtocolsCount() > 0) {
                ProtocolStringList alpnList = commonTlsContext.getAlpnProtocolsList();
                ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, alpnList);
                sslContextBuilder.applicationProtocolConfig(apn);
            }
            List<SslContextProvider.Callback> list = this.pendingCallbacks;
            synchronized (list) {
                sslContextCopy = this.sslContext = sslContextBuilder.build();
                pendingCallbacksCopy = this.clonePendingCallbacksAndClear();
            }
            this.makePendingCallbacks(sslContextCopy, pendingCallbacksCopy);
        }
        catch (Exception e) {
            this.onError(Status.fromThrowable(e));
            throw new RuntimeException(e);
        }
    }

    protected final void callPerformCallback(SslContextProvider.Callback callback, final SslContext sslContextCopy) {
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() {
                return sslContextCopy;
            }
        }, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCallback(SslContextProvider.Callback callback) {
        Preconditions.checkNotNull(callback, "callback");
        SslContext sslContextCopy = null;
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            if (this.sslContext != null) {
                sslContextCopy = this.sslContext;
            } else {
                this.pendingCallbacks.add(callback);
            }
        }
        if (sslContextCopy != null) {
            this.callPerformCallback(callback, sslContextCopy);
        }
    }

    private final void makePendingCallbacks(SslContext sslContextCopy, List<SslContextProvider.Callback> pendingCallbacksCopy) {
        for (SslContextProvider.Callback callback : pendingCallbacksCopy) {
            this.callPerformCallback(callback, sslContextCopy);
        }
    }

    public final void onError(Status error) {
        for (SslContextProvider.Callback callback : this.clonePendingCallbacksAndClear()) {
            callback.onException(error.asException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SslContextProvider.Callback> clonePendingCallbacksAndClear() {
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            ImmutableList<SslContextProvider.Callback> copy = ImmutableList.copyOf(this.pendingCallbacks);
            this.pendingCallbacks.clear();
            return copy;
        }
    }
}

