/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.InternalLogId;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;

final class XdsLogger {
    private static final Logger logger = Logger.getLogger(XdsLogger.class.getName());
    private final String prefix;

    static XdsLogger withLogId(InternalLogId logId) {
        Preconditions.checkNotNull(logId, "logId");
        return new XdsLogger(logId.toString());
    }

    static XdsLogger withPrefix(String prefix) {
        return new XdsLogger(prefix);
    }

    private XdsLogger(String prefix) {
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
    }

    boolean isLoggable(XdsLogLevel level) {
        Level javaLevel = XdsLogger.toJavaLogLevel(level);
        return logger.isLoggable(javaLevel);
    }

    void log(XdsLogLevel level, String msg) {
        Level javaLevel = XdsLogger.toJavaLogLevel(level);
        XdsLogger.logOnly(this.prefix, javaLevel, msg);
    }

    void log(XdsLogLevel level, String messageFormat, Object ... args2) {
        Level javaLogLevel = XdsLogger.toJavaLogLevel(level);
        if (logger.isLoggable(javaLogLevel)) {
            String msg = MessageFormat.format(messageFormat, args2);
            XdsLogger.logOnly(this.prefix, javaLogLevel, msg);
        }
    }

    private static void logOnly(String prefix, Level logLevel, String msg) {
        if (logger.isLoggable(logLevel)) {
            LogRecord lr = new LogRecord(logLevel, "[" + prefix + "] " + msg);
            lr.setLoggerName(logger.getName());
            lr.setSourceClassName(logger.getName());
            lr.setSourceMethodName("log");
            logger.log(lr);
        }
    }

    private static Level toJavaLogLevel(XdsLogLevel level) {
        switch (level) {
            case ERROR: 
            case WARNING: {
                return Level.FINE;
            }
            case INFO: {
                return Level.FINER;
            }
            case FORCE_INFO: {
                return Level.INFO;
            }
            case FORCE_WARNING: {
                return Level.WARNING;
            }
        }
        return Level.FINEST;
    }

    static enum XdsLogLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FORCE_INFO,
        FORCE_WARNING;

    }
}

