/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Metadata;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.internal.Matchers;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Joiner;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;

final class RoutingUtils {
    private RoutingUtils() {
    }

    @Nullable
    static VirtualHost findVirtualHostForHostName(List<VirtualHost> virtualHosts, String hostName) {
        int matchingLen = -1;
        boolean exactMatchFound = false;
        VirtualHost targetVirtualHost = null;
        for (VirtualHost vHost : virtualHosts) {
            for (String domain : vHost.domains()) {
                boolean selected = false;
                if (RoutingUtils.matchHostName(hostName, domain)) {
                    if (!domain.contains("*")) {
                        exactMatchFound = true;
                        targetVirtualHost = vHost;
                        break;
                    }
                    if (domain.length() > matchingLen) {
                        selected = true;
                    } else if (domain.length() == matchingLen && domain.startsWith("*")) {
                        selected = true;
                    }
                }
                if (!selected) continue;
                matchingLen = domain.length();
                targetVirtualHost = vHost;
            }
            if (!exactMatchFound) continue;
            break;
        }
        return targetVirtualHost;
    }

    private static boolean matchHostName(String hostName, String pattern) {
        Preconditions.checkArgument(hostName.length() != 0 && !hostName.startsWith(".") && !hostName.endsWith("."), "Invalid host name");
        Preconditions.checkArgument(pattern.length() != 0 && !pattern.startsWith(".") && !pattern.endsWith("."), "Invalid pattern/domain name");
        hostName = hostName.toLowerCase(Locale.US);
        pattern = pattern.toLowerCase(Locale.US);
        if (!pattern.contains("*")) {
            return hostName.equals(pattern);
        }
        if (pattern.length() == 1) {
            return true;
        }
        int index = pattern.indexOf(42);
        if (pattern.indexOf(42, index + 1) != -1) {
            return false;
        }
        if (index != 0 && index != pattern.length() - 1) {
            return false;
        }
        if (hostName.length() < pattern.length()) {
            return false;
        }
        if (index == 0 && hostName.endsWith(pattern.substring(1))) {
            return true;
        }
        return index == pattern.length() - 1 && hostName.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    static boolean matchRoute(VirtualHost.Route.RouteMatch routeMatch, String fullMethodName, Metadata headers, ThreadSafeRandom random) {
        if (!RoutingUtils.matchPath(routeMatch.pathMatcher(), fullMethodName)) {
            return false;
        }
        for (Matchers.HeaderMatcher headerMatcher : routeMatch.headerMatchers()) {
            if (RoutingUtils.matchHeader(headerMatcher, RoutingUtils.getHeaderValue(headers, headerMatcher.name()))) continue;
            return false;
        }
        Matchers.FractionMatcher fraction = routeMatch.fractionMatcher();
        return fraction == null || random.nextInt(fraction.denominator()) < fraction.numerator();
    }

    private static boolean matchPath(VirtualHost.Route.RouteMatch.PathMatcher pathMatcher, String fullMethodName) {
        if (pathMatcher.path() != null) {
            return pathMatcher.caseSensitive() ? pathMatcher.path().equals(fullMethodName) : pathMatcher.path().equalsIgnoreCase(fullMethodName);
        }
        if (pathMatcher.prefix() != null) {
            return pathMatcher.caseSensitive() ? fullMethodName.startsWith(pathMatcher.prefix()) : fullMethodName.toLowerCase().startsWith(pathMatcher.prefix().toLowerCase());
        }
        return pathMatcher.regEx().matches(fullMethodName);
    }

    private static boolean matchHeader(Matchers.HeaderMatcher headerMatcher, @Nullable String value) {
        boolean baseMatch;
        if (headerMatcher.present() != null) {
            return value == null == headerMatcher.present().equals(headerMatcher.inverted());
        }
        if (value == null) {
            return false;
        }
        if (headerMatcher.exactValue() != null) {
            baseMatch = headerMatcher.exactValue().equals(value);
        } else if (headerMatcher.safeRegEx() != null) {
            baseMatch = headerMatcher.safeRegEx().matches(value);
        } else if (headerMatcher.range() != null) {
            try {
                long numValue = Long.parseLong(value);
                baseMatch = numValue >= headerMatcher.range().start() && numValue <= headerMatcher.range().end();
            }
            catch (NumberFormatException ignored) {
                baseMatch = false;
            }
        } else {
            baseMatch = headerMatcher.prefix() != null ? value.startsWith(headerMatcher.prefix()) : value.endsWith(headerMatcher.suffix());
        }
        return baseMatch != headerMatcher.inverted();
    }

    @Nullable
    private static String getHeaderValue(Metadata headers, String headerName) {
        Metadata.Key<String> key;
        if (headerName.endsWith("-bin")) {
            return null;
        }
        if (headerName.equals("content-type")) {
            return "application/grpc";
        }
        try {
            key = Metadata.Key.of(headerName, Metadata.ASCII_STRING_MARSHALLER);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Iterable<String> values = headers.getAll(key);
        return values == null ? null : Joiner.on(",").join(values);
    }
}

